/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.DrawableElementXY;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.Visitable;
import com.inet.pdfc.model.Visitor;
import com.inet.pdfc.model.i18n.Msg;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class ShapeElement
extends DrawableElementXY
implements Visitable {
    static final long serialVersionUID = -4288921972079575311L;
    public static final int LINE_STYLE_NONE = 0;
    public static final int LINE_STYLE_SINGLE = 1;
    public static final int LINE_STYLE_DOUBLE = 2;
    public static final int LINE_STYLE_DASHED = 3;
    public static final int LINE_STYLE_DOTTED = 4;
    private boolean isClip;
    private double xOffset = Double.NaN;
    private double yOffset = Double.NaN;
    private Shape shape;
    private BasicStroke stroke;
    private Paint strokePaint;
    private Paint fillPaint;
    private transient float lineWidth;
    private transient List<Shape> segments;
    private static final double ALMOST_ZERO = 1.0E-5;

    public ShapeElement(boolean isClip, int pageIndex, Point2D offset, Shape shape, BasicStroke stroke, Paint strokePaint, Paint fillPaint) {
        super(pageIndex);
        this.isClip = isClip;
        this.shape = shape;
        this.stroke = stroke;
        this.strokePaint = strokePaint;
        this.fillPaint = fillPaint;
        if (offset != null) {
            this.setX(offset.getX());
            this.setY(offset.getY());
        }
        this.stroke = stroke;
        if (stroke != null) {
            this.lineWidth = this.stroke.getLineWidth();
        }
        if (this.lineWidth >= 10.0f) {
            this.lineWidth /= 20.0f;
        }
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        if (shape != null) {
            Rectangle2D bounds = shape.getBounds2D();
            super.setX(bounds.getX());
            super.setY(bounds.getY());
        }
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke bs) {
        this.stroke = bs;
        if (this.stroke != null) {
            this.lineWidth = this.stroke.getLineWidth();
        }
        if (this.lineWidth >= 10.0f) {
            this.lineWidth /= 20.0f;
        }
    }

    public static int getLineStyleFromStroke(BasicStroke bs) {
        if (bs == null) {
            return 0;
        }
        float[] dashArray = bs.getDashArray();
        if (dashArray == null || dashArray.length <= 1) {
            return 1;
        }
        float maxDotSize = bs.getLineWidth() * 1.5f;
        for (int i = 0; i < dashArray.length; ++i) {
            if (i % 2 != 0 || !(dashArray[i] > maxDotSize)) continue;
            return 3;
        }
        return 4;
    }

    public boolean getIsClip() {
        return this.isClip;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public int getLineStyle() {
        return ShapeElement.getLineStyleFromStroke(this.stroke);
    }

    public int createShapeSegments() {
        if (this.getShape() == null) {
            return 0;
        }
        this.segments = new ArrayList<Shape>();
        float curX = 0.0f;
        float curY = 0.0f;
        float startX = 0.0f;
        float startY = 0.0f;
        double tx = Double.isNaN(this.xOffset) ? 0.0 : this.xOffset;
        double ty = Double.isNaN(this.yOffset) ? 0.0 : this.yOffset;
        PathIterator pi = this.getShape().getPathIterator(AffineTransform.getTranslateInstance(tx, ty));
        while (!pi.isDone()) {
            float[] coords = new float[6];
            switch (pi.currentSegment(coords)) {
                case 0: {
                    curX = coords[0];
                    curY = coords[1];
                    startX = curX;
                    startY = curY;
                    break;
                }
                case 1: {
                    Line2D.Float line = new Line2D.Float(curX, curY, coords[0], coords[1]);
                    this.segments.add(line);
                    curX = coords[0];
                    curY = coords[1];
                    break;
                }
                case 3: {
                    CubicCurve2D.Float curve = new CubicCurve2D.Float(curX, curY, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    this.segments.add(curve);
                    curX = coords[4];
                    curY = coords[5];
                    break;
                }
                case 2: {
                    QuadCurve2D.Float curveQ = new QuadCurve2D.Float(curX, curY, coords[0], coords[1], coords[2], coords[3]);
                    this.segments.add(curveQ);
                    curX = coords[2];
                    curY = coords[3];
                    break;
                }
                case 4: {
                    if (curX != startX || curY != startY) {
                        Line2D.Float line2 = new Line2D.Float(curX, curY, startX, startY);
                        this.segments.add(line2);
                    }
                    curX = startX;
                    curY = startY;
                }
            }
            pi.next();
        }
        return this.segments.size();
    }

    public List<Shape> getShapeSegments() {
        if (this.segments == null && this.shape != null) {
            this.createShapeSegments();
        }
        return this.segments;
    }

    @Override
    public void setX(double x) {
        this.xOffset = !Double.isNaN(this.xOffset) ? (this.xOffset += x - this.getX()) : 0.0;
        this.segments = null;
        super.setX(x);
    }

    @Override
    public void setY(double y) {
        this.yOffset = !Double.isNaN(this.yOffset) ? (this.yOffset += y - this.getY()) : 0.0;
        this.segments = null;
        super.setY(y);
    }

    public boolean isEmpty() {
        return this.shape == null;
    }

    void setSegments(List<Shape> segments) {
        this.segments = segments;
    }

    public boolean clipToSize(Rectangle2D clip) {
        Shape shape = this.getShape();
        List<Shape> shapeSegments = this.getShapeSegments();
        if (shapeSegments.size() == 1) {
            shape = shapeSegments.get(0);
        }
        Rectangle2D myBounds = shape.getBounds2D();
        Rectangle2D pseudoBounds = myBounds.getBounds2D();
        if (shape instanceof Line2D) {
            if (myBounds.getHeight() < 1.0E-5) {
                pseudoBounds.setRect(myBounds.getX(), myBounds.getY(), myBounds.getWidth(), 1.0);
            } else if (myBounds.getWidth() < 1.0E-5) {
                pseudoBounds.setRect(myBounds.getX(), myBounds.getY(), 1.0, myBounds.getHeight());
            }
        }
        if (!clip.contains(pseudoBounds)) {
            if (clip.intersects(pseudoBounds)) {
                Rectangle2D.intersect(clip, myBounds, myBounds);
                if (shape instanceof Line2D) {
                    double x = myBounds.getX() - (Double.isNaN(this.xOffset) ? 0.0 : this.xOffset);
                    double y = myBounds.getY() - (Double.isNaN(this.yOffset) ? 0.0 : this.yOffset);
                    double x2 = x + myBounds.getWidth();
                    double y2 = y + myBounds.getHeight();
                    this.setShape(new GeneralPath(new Line2D.Double(x, y, x2, y2)));
                    this.createShapeSegments();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.shape == null) {
            if (this.segments == null || this.segments.size() == 0) {
                return null;
            }
            this.shape = new Polygon();
            Path2D.Double path = new Path2D.Double();
            for (Shape s : this.segments) {
                path.append(s, true);
            }
            this.shape = path;
        }
        double tx = Double.isNaN(this.xOffset) ? 0.0 : this.xOffset;
        double ty = Double.isNaN(this.yOffset) ? 0.0 : this.yOffset;
        Rectangle2D b = this.shape.getBounds2D();
        b.setRect(b.getX() + tx, b.getY() + ty, b.getWidth(), b.getHeight());
        return b;
    }

    @Override
    public int getCompareHash() {
        return 4;
    }

    @Override
    public ElementType getType() {
        return ElementType.Shape;
    }

    public void setStrokePaint(Paint paint) {
        this.strokePaint = paint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    @Override
    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    @Override
    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public String toString() {
        String shapeBounds;
        Rectangle2D bounds = this.getBounds();
        String string = shapeBounds = bounds != null ? "(" + bounds.getX() + "," + bounds.getY() + "," + bounds.getWidth() + "," + bounds.getHeight() + ")" : "";
        if (this.isClip) {
            return "Clip-Shape " + shapeBounds;
        }
        return (this.shape != null ? this.shape.getClass().getSimpleName() : "Unknown") + "-Shape " + shapeBounds;
    }

    @Override
    public String getLabel() {
        Rectangle2D bounds = this.getBounds();
        String width = bounds != null ? Long.toString(Math.round(bounds.getWidth())) : "null";
        String height = bounds != null ? Long.toString(Math.round(bounds.getHeight())) : "null";
        return Msg.getMsg("ElementType." + this.getType(), width, height);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

