/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.print.DefaultColorProvider;
import java.awt.Color;
import java.util.Properties;
import javax.annotation.Nonnull;

@JsonData
@PublicApi
public class DefaultSetting
implements Settings {
    private static final String MARKER = ".marker.";
    private static final String VISIBLE = ".visible.";
    private static final String COLOR = ".color.";
    private Properties settings = new Properties();

    public DefaultSetting() {
        DefaultColorProvider defaultColorProvider = new DefaultColorProvider();
        for (DiffGroup.GroupType groupType : DiffGroup.GroupType.valuesVisible()) {
            this.setMarkerColor(defaultColorProvider.getMarkerColor(groupType), groupType);
            this.setColor(defaultColorProvider.getOutlineColor(groupType), groupType);
        }
        this.setColor(Color.blue, Settings.METAOPTION.ALLOUTLINEMARKER);
        this.setEnabled(true, Settings.EXPORT.values());
        this.setEnabled(false, Settings.EXPORT.SCALETOPAGEHEIGHT);
        this.setEnabled(true, DiffGroup.GroupType.valuesVisible());
        this.setEnabled(false, Settings.OPTION.values());
        this.setEnabled(true, Settings.OPTION.HEADERFOOTER);
    }

    @Override
    public void setMarkerColor(@Nonnull Color color, @Nonnull DiffGroup.GroupType content) {
        this.settings.put(".color..marker." + content.getTyp() + content.name(), Integer.toString(color.getRGB()));
    }

    @Override
    public void setColor(Color color, @Nonnull ColorSetting setting) {
        this.settings.put(COLOR + setting.getTyp() + setting.name(), Integer.toString(color.getRGB()));
    }

    @Override
    public void setEnabled(boolean isVisible, VisibilitySetting ... visibles) {
        for (VisibilitySetting visible : visibles) {
            this.settings.put(VISIBLE + visible.getTyp() + visible.name(), Boolean.toString(isVisible));
        }
    }

    @Override
    public boolean isEnabled(VisibilitySetting content) {
        return this.settings.getProperty(VISIBLE + content.getTyp() + content.name(), !content.getTyp().equals("OPTION") + "").equalsIgnoreCase("true");
    }

    public String toString() {
        String value = "([ ";
        for (Settings.EXPORT eXPORT : Settings.EXPORT.values()) {
            value = value + eXPORT.name() + ":" + this.isEnabled(eXPORT) + " ";
        }
        value = value + "][ ";
        for (Enum enum_ : DiffGroup.GroupType.valuesVisible()) {
            value = value + enum_.name() + ":" + this.getMarkerColor((DiffGroup.GroupType)enum_) + this.getOutlineColor((DiffGroup.GroupType)enum_) + " ";
        }
        return value + "])";
    }

    @Override
    @Nonnull
    public Color getMarkerColor(@Nonnull DiffGroup.GroupType content) {
        return new Color(Integer.parseInt(this.settings.getProperty(".color..marker." + content.getTyp() + content.name(), "0")), true);
    }

    @Override
    public Color getColor(@Nonnull ColorSetting colorSetting) {
        int rgba = Integer.parseInt(this.settings.getProperty(COLOR + colorSetting.getTyp() + colorSetting.name(), "-1"));
        return rgba == -1 ? null : new Color(rgba, true);
    }

    @Override
    @Nonnull
    public Color getOutlineColor(DiffGroup.GroupType content) {
        return this.getColor(content);
    }
}

