/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.util;

import com.inet.error.HasErrorCode;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

public class StringFunctions {
    public static final Charset UTF8 = StandardCharsets.UTF_8;

    private StringFunctions() {
    }

    public static final String traceToString(Throwable throwable) {
        ByteArrayOutputStream target = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(target));
        return new String(target.toByteArray());
    }

    @Nonnull
    public static final String getUserFriendlyErrorMessage(@Nonnull Throwable th) {
        String errormsg = th.getMessage();
        try {
            if ((th instanceof RuntimeException || th instanceof Error) && (errormsg == null || errormsg.length() < 20)) {
                StackTraceElement stackTraceElement;
                StackTraceElement[] stackTrace;
                if (errormsg == null) {
                    errormsg = th.getClass().getSimpleName();
                }
                if ((stackTrace = th.getStackTrace()).length > 0 && (stackTraceElement = stackTrace[0]) != null) {
                    errormsg = errormsg + " - at " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
                }
            }
            if (!(th instanceof RuntimeException) && !(th instanceof HasErrorCode)) {
                String[] classWords = th.getClass().getSimpleName().split("(?<=[a-z])(?=[A-Z])");
                StringBuilder className = new StringBuilder();
                for (String word : classWords) {
                    if ("Exception".equals(word) || "Error".equals(word)) continue;
                    if (word.endsWith("Exception")) {
                        word = word.substring(0, word.length() - "Exception".length());
                    }
                    className.append(word).append(' ');
                }
                errormsg = className.toString().trim() + ": " + errormsg;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (errormsg == null) {
            errormsg = th.toString();
        }
        return errormsg;
    }

    public static String getHTMLEncoded(String toConvert) {
        StringBuffer text = new StringBuffer();
        int lastChar = 0;
        block7: for (int i = 0; i < toConvert.length(); ++i) {
            char c = toConvert.charAt(i);
            if (c > '\u007f') {
                text.append("&#" + c + ";");
            } else {
                switch (c) {
                    case '\"': {
                        text.append("&quot;");
                        break;
                    }
                    case '<': {
                        text.append("&lt;");
                        break;
                    }
                    case '>': {
                        text.append("&gt;");
                        break;
                    }
                    case '&': {
                        text.append("&amp;");
                        break;
                    }
                    case ' ': {
                        if (lastChar == 32) {
                            text.append("&nbsp;");
                            lastChar = 0;
                            continue block7;
                        }
                    }
                    default: {
                        text.append(c);
                    }
                }
            }
            lastChar = c;
        }
        return text.toString();
    }

    public static String encodeHTML(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        StringBuilder result = null;
        int off = 0;
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            block0 : switch (ch) {
                case '\n': 
                case '<': 
                case '>': {
                    if (result == null) {
                        result = new StringBuilder(length);
                    }
                    result.append(text, off, i);
                    off = i + 1;
                    switch (ch) {
                        case '<': {
                            result.append("&#60;");
                            break block0;
                        }
                        case '>': {
                            result.append("&#62;");
                            break block0;
                        }
                        case '\n': {
                            result.append("<BR>");
                        }
                    }
                }
            }
        }
        if (result == null) {
            return text;
        }
        result.append(text, off, length);
        return result.toString();
    }

    public static Boolean likeCaseSensitive(String fi, String pa) {
        if (pa.length() == 0) {
            return Boolean.FALSE;
        }
        char[] search = fi.toCharArray();
        char[] mask = pa.toCharArray();
        int mIdx = 0;
        int sIdx = 0;
        boolean range = false;
        block4: while (mask.length > mIdx && search.length > sIdx) {
            char m = mask[mIdx++];
            switch (m) {
                case '*': {
                    range = true;
                    continue block4;
                }
                case '?': {
                    ++sIdx;
                    continue block4;
                }
            }
            if (range) {
                while (sIdx < search.length && search[sIdx] != m) {
                    ++sIdx;
                }
                if (sIdx >= search.length) {
                    return Boolean.FALSE;
                }
                int lastMIdx = mIdx - 1;
                int lastSIdx = ++sIdx;
                while (mask.length > mIdx && search.length > sIdx) {
                    if (search[sIdx] != (m = mask[mIdx++])) {
                        Boolean matchRight;
                        if (m == '*') {
                            --mIdx;
                            break;
                        }
                        if (m == '?' && (matchRight = StringFunctions.likeCaseSensitive(fi.substring(sIdx), pa.substring(--mIdx))).booleanValue()) {
                            return Boolean.TRUE;
                        }
                        mIdx = lastMIdx;
                        sIdx = lastSIdx;
                        continue block4;
                    }
                    ++sIdx;
                }
                if (mask.length == mIdx && search.length > sIdx) {
                    mIdx = lastMIdx;
                    sIdx = lastSIdx;
                    continue;
                }
                range = false;
                continue;
            }
            if (search[sIdx] != m) {
                return Boolean.FALSE;
            }
            ++sIdx;
        }
        while (mask.length > mIdx) {
            if (mask[mIdx++] == '*') continue;
            return Boolean.FALSE;
        }
        if (search.length > sIdx && !range) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static String numberToRomanNumerals(long n) {
        if (n <= 0L) {
            return String.valueOf(0);
        }
        StringBuilder result = new StringBuilder();
        NumSet[] symbols = NumSet.values();
        for (int i = symbols.length - 1; i >= 0; --i) {
            while (n >= (long)symbols[i].value) {
                result.append((Object)symbols[i]);
                n -= (long)symbols[i].value;
            }
        }
        return result.toString();
    }

    public static String numberToAlphabetic(int num) {
        StringBuilder result = new StringBuilder();
        while (num > 0) {
            int remainder = --num % 26;
            char digit = (char)(remainder + 97);
            result.insert(0, digit);
            num = (num - remainder) / 26;
        }
        return result.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    private static enum NumSet {
        I(1),
        IV(4),
        V(5),
        IX(9),
        X(10),
        XL(40),
        L(50),
        XC(90),
        C(100),
        CD(400),
        D(500),
        CM(900),
        M(1000);

        private final int value;

        private NumSet(int value) {
            this.value = value;
        }
    }
}

