/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import java.io.IOException;
import java.io.Reader;

public class FastStringReader
extends Reader {
    private final String str;
    private final int length;
    private int idx;

    public FastStringReader(String str) {
        this.str = str;
        this.length = str.length();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.length <= this.idx) {
            return -1;
        }
        int count = Math.min(this.length - this.idx, len);
        this.str.getChars(this.idx, this.idx + count, cbuf, off);
        this.idx += count;
        return count;
    }

    @Override
    public int read() throws IOException {
        if (this.length <= this.idx) {
            return -1;
        }
        return this.str.charAt(this.idx++);
    }

    @Override
    public void close() throws IOException {
        this.idx = this.length;
    }
}

