/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.BonParser;
import com.inet.lib.json.BonWriter;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonTypeResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Map;

public class Bon {
    public byte[] toBinary(Object data) {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        this.toBinary(data, out);
        return out.toByteArray();
    }

    public void toBinary(Object data, OutputStream out) {
        try {
            BonWriter writer = new BonWriter(out);
            writer.writeValue(data);
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public <T> T fromBinary(byte[] binaryData, Class<T> clazz) {
        return this.fromBinary(binaryData, clazz, null, null);
    }

    public <T> T fromBinary(byte[] binaryData, Type type) {
        return this.fromBinary(binaryData, type, null, null);
    }

    public <T> T fromBinary(byte[] binaryData, Type type, Map<Object, Map<String, Object>> extraFields, JsonTypeResolver typeResolver) {
        try {
            return this.fromBinary(new FastByteArrayInputStream(binaryData), type, extraFields, typeResolver);
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public <T> T fromBinary(InputStream input, Class<T> clazz) throws IOException {
        return this.fromBinary(input, clazz, null, null);
    }

    public <T> T fromBinary(InputStream input, Type type, Map<Object, Map<String, Object>> extraFields, JsonTypeResolver typeResolver) throws IOException {
        try {
            if (typeResolver == null) {
                typeResolver = JsonTypeResolver.INSTANCE;
            }
            BonParser reader = new BonParser(input, extraFields, typeResolver);
            return (T)reader.parseValue(type);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }
}

