/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results.painter;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.model.DiffGroup;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class DiffConstants {
    private static final Map<DiffGroup.GroupType, Coloring> COLOR_MAP = new HashMap<DiffGroup.GroupType, Coloring>();

    public static Color getMarkerColor(DiffGroup.GroupType t) {
        return COLOR_MAP.get(t).markerColor;
    }

    public static Color getOutlineColor(DiffGroup.GroupType t) {
        return COLOR_MAP.get(t).outlineColor;
    }

    public static Color getScrollBarMarkerColor(DiffGroup.GroupType t) {
        return COLOR_MAP.get(t).scrollBarMarker;
    }

    public static Color changeAlpha(Color baseColor, int addAlpha) {
        int alphaValue = baseColor.getAlpha() + addAlpha;
        if (alphaValue > 255) {
            alphaValue = 255;
        } else if (alphaValue < 0) {
            alphaValue = 0;
        }
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alphaValue);
    }

    public static void changeColoring(DiffGroup.GroupType groupType, Color color) {
        Coloring coloring = COLOR_MAP.get(groupType);
        if (coloring != null) {
            coloring.markerColor = color;
        }
    }

    static {
        COLOR_MAP.put(DiffGroup.GroupType.AddedOrRemoved, new Coloring(Color.RED, 30, 40));
        COLOR_MAP.put(DiffGroup.GroupType.Replaced, new Coloring(new Color(255, 170, 0), 22, 80));
        COLOR_MAP.put(DiffGroup.GroupType.Modified, new Coloring(new Color(0, 153, 60), 17, 100));
        COLOR_MAP.put(DiffGroup.GroupType.Sync, new Coloring(new Color(0, 255, 0, 0), 0, 0));
        COLOR_MAP.put(DiffGroup.GroupType.MetadataChanged, new Coloring(new Color(0, 128, 196, 255), 10, 40));
    }

    private static class Coloring {
        private Color markerColor;
        private Color outlineColor;
        private Color scrollBarMarker;

        public Coloring(Color typeColor, int blueAlpha, int overlayAlpha) {
            this.markerColor = new Color(0, 0, 255, blueAlpha);
            this.outlineColor = new Color(typeColor.getRed(), typeColor.getGreen(), typeColor.getBlue(), overlayAlpha);
            this.scrollBarMarker = typeColor;
        }
    }
}

