/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.FontInfo;
import com.inet.pdfc.model.Visitable;
import com.inet.pdfc.model.Visitor;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

@InternalApi
public class TextElement
extends DrawableElement
implements Visitable {
    static final long serialVersionUID = 999238012010077L;
    private String text;
    private float fontSize;
    private double estimatedSlope;
    private double estimatedRotation;
    private static double[] DEFAULT_ROTATION = new double[2];
    private double[] m = null;
    private double[] charWidths;
    private double[] kerning;
    private Rectangle2D clip;
    private double textWidth = -1.0;
    private double textHeight;
    private Rectangle2D bounds;
    private int wsWidth;
    private int wsWidthScaled;
    private boolean underline = false;
    private boolean strikethrough = false;
    private int border = 0;
    private boolean isIndex = false;
    private final FontInfo fontInfo;
    private Paint strokePaint;
    private Paint fillPaint;
    private int styleOverride;
    private boolean wsWidthArtificial;

    public TextElement(FontInfo fontInfo, float fontSize, AffineTransform transform, String text, Paint fillPaint, Paint strokePaint, double[] charWidths, double[] kerning, boolean replaceZeroChar) {
        super(0);
        double slope;
        this.fontInfo = fontInfo;
        if (replaceZeroChar) {
            boolean doReplace = false;
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) >= ' ') continue;
                doReplace = true;
                break;
            }
            if (doReplace) {
                char[] charArray = text.toCharArray();
                for (int i = 0; i < charArray.length; ++i) {
                    if (charArray[i] >= ' ') continue;
                    charArray[i] = 32;
                }
                text = new String(charArray);
            }
        }
        this.text = text;
        this.setFillPaint(fillPaint);
        this.setStrokePaint(strokePaint);
        this.charWidths = charWidths != null ? (double[])charWidths.clone() : new double[]{};
        this.kerning = kerning != null ? (double[])kerning.clone() : null;
        this.m = new double[6];
        transform.getMatrix(this.m);
        double[] rs = TextElement.getRotationAndShearAngle(transform);
        this.estimatedRotation = rs[0];
        this.estimatedSlope = rs[1];
        this.textHeight = Math.ceil(fontInfo.getAscend(1) * (float)((int)(fontSize * 20.0f))) / 20.0;
        this.wsWidth = fontInfo.getMetrics((int)(fontSize * 20.0f)).charWidth(' ');
        boolean bl = this.wsWidthArtificial = !fontInfo.getMetrics((int)(fontSize * 20.0f)).getFont().canDisplay(' ');
        if (this.wsWidth <= 0) {
            this.wsWidth = (int)(this.textHeight * 5.0);
        }
        if (!transform.isIdentity()) {
            double factor = Math.sqrt(transform.getScaleX() * transform.getScaleX() + transform.getShearY() * transform.getShearY());
            this.wsWidthScaled = (int)Math.round((double)this.wsWidth * factor);
            this.fontSize = (float)((double)fontSize * factor);
        } else {
            this.wsWidthScaled = this.wsWidth;
            this.fontSize = fontSize;
        }
        this.calculateBounds(transform, this.getTextWidth(), this.getTextHeight());
        if (this.estimatedSlope != 0.0 && this.estimatedSlope != Math.PI && (slope = Math.abs(this.estimatedSlope > 1.5707963267948966 ? this.estimatedSlope - Math.PI : this.estimatedSlope)) > 0.05 && slope < 0.7853981633974483) {
            this.styleOverride |= 2;
        }
    }

    private static double[] getRotationAndShearAngle(AffineTransform t) {
        if (t.getShearX() == -t.getShearY() && Math.abs(t.getScaleX()) == Math.abs(t.getScaleY())) {
            if (t.getShearX() == 0.0 && t.getScaleX() > 0.0) {
                return DEFAULT_ROTATION;
            }
            return new double[]{Math.atan2(t.getShearY(), t.getScaleX()), 0.0};
        }
        double[] m = new double[4];
        t.getMatrix(m);
        t = new AffineTransform(m);
        Point2D.Double p = new Point2D.Double(1.0, 0.0);
        t.transform(p, p);
        double rotation = Math.atan2(p.getY(), p.getX());
        p = new Point2D.Double(0.0, 1.0);
        t.transform(p, p);
        double shear = 1.5707963267948966 + rotation - Math.atan2(p.getY(), p.getX());
        return new double[]{rotation, shear};
    }

    public void calculateBounds(AffineTransform transform, double textWidth, double textHeight) {
        if (transform.getScaleX() == 1.0 && transform.getShearX() == 0.0 && transform.getScaleY() == -1.0 && transform.getShearY() == 0.0) {
            this.bounds = new Rectangle2D.Double(transform.getTranslateX(), transform.getTranslateY(), this.getTextWidth(), -textHeight);
        } else {
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, textHeight, this.getTextWidth(), -textHeight);
            Point2D.Double p = new Point2D.Double();
            transform.transform(new Point2D.Double(rect.x, rect.y), p);
            this.bounds = new Rectangle2D.Double(p.x, p.y, 0.0, 0.0);
            this.bounds.add(transform.transform(new Point2D.Double(rect.x + rect.width, rect.y), p));
            this.bounds.add(transform.transform(new Point2D.Double(rect.x + rect.width, rect.y + rect.height), p));
            this.bounds.add(transform.transform(new Point2D.Double(rect.x, rect.y + rect.height), p));
            if (Math.abs(transform.getTranslateY() - this.bounds.getY()) > 0.5) {
                this.bounds = new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY() + this.bounds.getHeight(), this.bounds.getWidth(), -this.bounds.getHeight());
            }
        }
    }

    public static Rectangle2D.Double createTransformedBounds(AffineTransform at, Rectangle2D.Double rect) {
        Point2D.Double p = new Point2D.Double();
        at.transform(new Point2D.Double(rect.x, rect.y), p);
        Rectangle2D.Double bounds = new Rectangle2D.Double(p.x, p.y, 0.0, 0.0);
        bounds.add(at.transform(new Point2D.Double(rect.x + rect.width, rect.y), p));
        bounds.add(at.transform(new Point2D.Double(rect.x + rect.width, rect.y + rect.height), p));
        bounds.add(at.transform(new Point2D.Double(rect.x, rect.y + rect.height), p));
        return bounds;
    }

    public int getWhitespaceWidth() {
        return this.wsWidth;
    }

    public int getWhitespaceWidthScaled() {
        return this.wsWidthScaled;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getTextSlope() {
        return this.estimatedSlope;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public double getTextHeight() {
        return this.textHeight;
    }

    public double[] getCharacterWidths() {
        int length = this.getText().length();
        if (this.charWidths.length > length) {
            double[] tmp = new double[length];
            System.arraycopy(this.charWidths, 0, tmp, 0, length);
            this.charWidths = tmp;
        }
        return this.charWidths;
    }

    public double getTextWidth() {
        if (this.textWidth == -1.0) {
            this.textWidth = 0.0;
            for (int i = 0; i < this.charWidths.length; ++i) {
                this.textWidth += this.charWidths[i];
            }
        }
        return this.textWidth;
    }

    public double[] getKerningArray() {
        return this.kerning;
    }

    public void setKerning(double[] kerning) {
        this.kerning = kerning;
    }

    public void setCharWidths(double[] charWidths) {
        this.charWidths = charWidths;
        this.textWidth = -1.0;
    }

    public Rectangle2D getClip() {
        return this.clip;
    }

    public void setClip(Rectangle2D clip) {
        this.clip = clip;
    }

    public double[] getTransformMatrix() {
        return this.m;
    }

    public boolean isUnderlined() {
        return this.underline;
    }

    public void setUnderlined(boolean isUnderlined) {
        this.underline = isUnderlined;
    }

    public void setStrikethrough(boolean strikethrough) {
        this.strikethrough = strikethrough;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public void setBorder(int border) {
        if (border < 0 || border > 15) {
            return;
        }
        this.border = border;
    }

    public int getBorder() {
        return this.border;
    }

    public boolean hasBorder() {
        return this.border > 0;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public double getX() {
        return this.bounds.getX();
    }

    @Override
    public double getY() {
        return this.bounds.getY();
    }

    @Override
    public void setX(double x) {
        double diff = x - this.bounds.getX();
        this.bounds.setRect(x, this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
        this.m[4] = this.m[4] + diff;
    }

    @Override
    public void setY(double y) {
        double diff = y - this.bounds.getY();
        this.bounds.setRect(this.bounds.getX(), y, this.bounds.getWidth(), this.bounds.getHeight());
        this.m[5] = this.m[5] + diff;
    }

    public String toString() {
        return "\"" + this.text + "\" (" + this.bounds.getX() + "," + this.bounds.getY() + "," + this.bounds.getWidth() + "," + this.bounds.getHeight() + ")";
    }

    public float getFontSize() {
        return this.fontSize;
    }

    @Override
    public int getCompareHash() {
        return this.text.hashCode();
    }

    @Override
    public double getRotation() {
        return this.estimatedRotation;
    }

    public int getStyleOverride() {
        return this.styleOverride;
    }

    @Override
    public ElementType getType() {
        return ElementType.Text;
    }

    public void setStrokePaint(Paint paint) {
        this.strokePaint = paint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    @Override
    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    @Override
    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setIndex(boolean isIndex) {
        this.isIndex = isIndex;
    }

    public boolean isIndex() {
        return this.isIndex;
    }

    public void setTextHeight(double textHeight) {
        this.textHeight = textHeight;
    }

    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @Override
    public String getLabel() {
        return this.text;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public boolean hasArtificialWhiteSpace() {
        return this.wsWidthArtificial;
    }

    public void setTransformMatrix(double[] newMatrix) {
        this.m = newMatrix;
    }

    public void overrideWhiteSpaceWidth(double newValue) {
        this.wsWidth = (int)(newValue * 20.0);
        if (this.m[0] != 1.0 || this.m[1] != 1.0) {
            double factor = Math.sqrt(this.m[0] * this.m[0] + this.m[1] * this.m[1]);
            this.wsWidthScaled = (int)Math.round((double)this.wsWidth * factor);
        } else {
            this.wsWidthScaled = this.wsWidth;
        }
    }
}

