/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonData
@PublicApi
public abstract class PdfSource
implements Comparable<PdfSource>,
Serializable {
    protected static final String KEY_PASSWORD = "PASSWORD";
    protected static final String KEY_NAME = "NAME";
    protected static final String KEY_PATH = "PATH";
    private static final String KEY_PAGE_LIMIT = "LIMIT";
    private Map<String, String> metaProperties = new HashMap<String, String>();

    public void setPageLimit(int pageLimited) {
        if (pageLimited > 0) {
            this.getMetaProperties().put(KEY_PAGE_LIMIT, pageLimited + "");
        } else {
            this.getMetaProperties().remove(KEY_PAGE_LIMIT);
        }
    }

    public String getName() {
        return this.getMetaProperties().get(KEY_NAME);
    }

    public String getPath() {
        return this.getMetaProperties().get(KEY_PATH);
    }

    public abstract long getLastModified();

    public abstract long getSize();

    public String getPassword() {
        return this.metaProperties.get(KEY_PASSWORD);
    }

    public void setPassword(String password) {
        this.metaProperties.put(KEY_PASSWORD, password);
    }

    protected Map<String, String> getMetaProperties() {
        return this.metaProperties;
    }

    @Override
    public int compareTo(PdfSource o) {
        if (o == null) {
            return 1;
        }
        int result = this.getName().toLowerCase().compareTo(o.getName().toLowerCase());
        return result != 0 ? result : this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PdfSource)) {
            return false;
        }
        PdfSource other = (PdfSource)obj;
        if (other.getSize() != this.getSize()) {
            return false;
        }
        return this.getName() != null ? this.getName().equals(other.getName()) : other.getName() == null;
    }

    public int hashCode() {
        return (int)this.getSize() + (this.getName() != null ? this.getName().hashCode() : 0);
    }
}

