/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mdns.record;

import com.inet.mdns.MDNSInputStream;
import com.inet.mdns.MDNSOutputStream;
import com.inet.mdns.record.AAAARecord;
import com.inet.mdns.record.ARecord;
import com.inet.mdns.record.PtrRecord;
import com.inet.mdns.record.SrvRecord;
import com.inet.mdns.record.TxtRecord;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import javax.annotation.Nullable;

public abstract class Record {
    public static final int TYPE_A = 1;
    public static final int TYPE_PTR = 12;
    public static final int TYPE_TXT = 16;
    public static final int TYPE_AAAA = 28;
    public static final int TYPE_SRV = 33;
    public static final int TYPE_ANY = 255;
    public static final int CLASS_INTERNET = 1;
    public static final int TTL = 30;
    private String name;

    @Nullable
    public static Record read(MDNSInputStream in) throws IOException {
        String name = in.readName();
        int typeId = in.readUnsignedShort();
        in.readUnsignedShort();
        in.readInt();
        int len = in.readUnsignedShort();
        switch (typeId) {
            case 1: {
                if (len != 4) {
                    throw new IOException("IPv4 address length != 4");
                }
                return new ARecord(name, (Inet4Address)InetAddress.getByAddress(in.readBytes(4)));
            }
            case 28: {
                if (len != 16) {
                    throw new IOException("IPv6 address length != 16");
                }
                return new AAAARecord(name, (Inet6Address)InetAddress.getByAddress(in.readBytes(16)));
            }
            case 12: {
                return new PtrRecord(name, in.readName());
            }
            case 16: {
                return new TxtRecord(name, in.readUTF(in.read()));
            }
            case 33: {
                return new SrvRecord(name, in.readUnsignedShort(), in.readUnsignedShort(), in.readUnsignedShort(), in.readName());
            }
        }
        in.skip(len);
        return null;
    }

    protected Record(String name) {
        this.name = name;
    }

    public void writeTo(MDNSOutputStream out) {
        out.writeName(this.name);
        out.writeShort(this.getType());
        out.writeShort(32769);
        out.writeInt(30);
        MDNSOutputStream payloadOut = new MDNSOutputStream();
        this.writePayloadTo(payloadOut);
        byte[] byteArray = payloadOut.toByteArray();
        out.writeShort(byteArray.length);
        out.write(byteArray, 0, byteArray.length);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.name + "]";
    }

    public abstract int getType();

    abstract void writePayloadTo(MDNSOutputStream var1);
}

