/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.message;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.config.FilterType;
import com.inet.pdfc.generator.message.Chunk;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.List;

@PublicApi
public interface HighlightData
extends Chunk {
    public List<Highlight> getPageHighlights(int var1, boolean var2);

    public FilterType getTypeKey();

    public String getFilterKey();

    @JsonData
    @PublicApi
    public static class Highlight
    extends Rectangle {
        private String type;
        private String caption;
        private int rgb;
        private transient Image image;
        private Appearance appearance;
        private String renderCacheKey;

        Highlight() {
        }

        public Highlight(int x, int y, int width, int height, String caption, Appearance appearance, Color color) {
            super(x, y, width, height);
            this.caption = caption;
            this.appearance = appearance;
            this.rgb = color.getRGB();
        }

        public String getCaption() {
            return this.caption;
        }

        public Color getColor() {
            return new Color(this.rgb, true);
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public boolean isAnnotation() {
            return false;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public Appearance getAppearance() {
            return this.appearance;
        }

        public String getRenderCacheKey() {
            return this.renderCacheKey;
        }

        public void setRenderCacheKey(String renderCacheKey) {
            this.renderCacheKey = renderCacheKey;
        }

        @Override
        public boolean contains(int x, int y) {
            if (this.image != null && x > this.x && x < this.x + this.image.getWidth(null) && y < this.y && y > this.y - this.image.getHeight(null)) {
                return true;
            }
            return super.contains(x, y);
        }

        @PublicApi
        public static enum Appearance {
            RECTANGLE,
            FILLED_RECTANGLE,
            STRIKEOUT,
            UNDERLINE,
            CUSTOM;

        }
    }
}

