/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.PublicApi;
import com.inet.pdfc.config.CompareType;
import com.inet.pdfc.config.FilterType;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.TextStyleType;
import com.inet.pdfc.modules.ModuleType;
import com.inet.pdfc.normalizers.NormalizerType;
import com.inet.pdfc.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

@PublicApi
public class PDFCProperty<T> {
    private static final HashMap<String, PDFCProperty<?>> PROPERTIES = new HashMap();
    private static final HashMap<String, PDFCProperty<?>> DEPRECATED = new HashMap();
    public static final PDFCProperty<String> CREATE_DIFFIMAGES;
    public static final PDFCProperty<Boolean> CREATE_XORIMAGES;
    public static final PDFCProperty<Boolean> CREATE_ORIGIMAGES;
    public static final PDFCProperty<Double> IMAGE_SCALE_FACTOR;
    public static final PDFCProperty<String> LOG_LEVEL;
    public static final PDFCProperty<String> LOG_FILE;
    public static final PDFCProperty<Integer> MAX_ERRORS_PER_FILE;
    @Deprecated
    public static final PDFCProperty<ModuleType> MODULES;
    @Deprecated
    public static final PDFCProperty<NormalizerType> NORMALIZERS;
    public static final PDFCProperty<Integer> TOLERANCE_BOX_ROUND_EDGES;
    public static final PDFCProperty<Integer> TOLERANCE_IMAGE_DISTANCE;
    public static final PDFCProperty<Double> TOLERANCE_IMAGE_PIXEL_VALUE;
    public static final PDFCProperty<Double> TOLERANCE_IMAGE_SIZE;
    public static final PDFCProperty<Integer> TOLERANCE_LINE_POSITION;
    public static final PDFCProperty<Integer> TOLERANCE_LINE_SIZE;
    public static final PDFCProperty<Boolean> TOLERANCE_LINE_STYLE;
    public static final PDFCProperty<Integer> TOLERANCE_LINE_THICKNESS;
    public static final PDFCProperty<Integer> TOLERANCE_PAGE_LEFTCORNER;
    public static final PDFCProperty<Double> TOLERANCE_PAGE_RATIO;
    public static final PDFCProperty<Integer> TOLERANCE_PAGE_SIZE;
    public static final PDFCProperty<Double> TOLERANCE_UNDERLINE_LENGTH;
    public static final PDFCProperty<Integer> TOLERANCE_TEXT_LOCATION;
    public static final PDFCProperty<Double> TOLERANCE_TEXT_SIZE;
    public static final PDFCProperty<Double> TOLERANCE_COLOR;
    public static final PDFCProperty<TextStyleType> COMPARE_TEXT_STYLES;
    public static final PDFCProperty<Double> TEXT_ALIGN_RATIO;
    public static final PDFCProperty<Boolean> COMPARE_TEXT_CASE_SENSITIVE;
    public static final PDFCProperty<Boolean> COMPARE_LINE_STYLES;
    public static final PDFCProperty<Boolean> USE_PIXEL_MEDIUM_VALUE;
    public static final PDFCProperty<Integer> FIXED_HEADER_SIZE;
    public static final PDFCProperty<Integer> FIXED_FOOTER_SIZE;
    @Deprecated
    public static final PDFCProperty<FilterType> CONTINUOUS_FILTERS;
    public static final PDFCProperty<String> FILTERS;
    @Deprecated
    public static final PDFCProperty<CompareType> CONTINUOUS_COMPARE_TYPES;
    public static final PDFCProperty<CompareType> COMPARE_TYPES;
    public static final PDFCProperty<Integer> CONTINUOUS_DETECT_PAGES;
    public static final PDFCProperty<String> CONTINUOUS_COMPARE;
    public static final PDFCProperty<Boolean> EXPORT_PDF_ALWAYS;
    public static final PDFCProperty<String> FILTER_PATTERNS;
    @Deprecated
    public static final PDFCProperty<Boolean> INVISIBLEELEMENTS_HIDE_ROTATION;
    private final String name;
    private T defaultValue;
    private Class<?> type;
    private Number lowerBound;
    private Number upperBound;
    private Object[] validValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDFCProperty(String name, T defaultValue, Class<T> type) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.type = type;
        if (DEPRECATED.containsKey(name)) {
            DEPRECATED.put(name, this);
            return;
        }
        HashMap<String, PDFCProperty<?>> hashMap = PROPERTIES;
        synchronized (hashMap) {
            if (PROPERTIES.containsKey(name)) {
                PDFCProperty<?> current = PROPERTIES.get(name);
                if (current.getType() == type && current.getDefaultValue() == defaultValue) {
                    return;
                }
                throw new IllegalStateException("A property with the same name '" + name + "' already exists.");
            }
            PROPERTIES.put(name, this);
        }
    }

    public PDFCProperty(String name, int defaultValue, int lowerBound, int upperBound) {
        this(name, defaultValue, Integer.class);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public PDFCProperty(String name, double defaultValue, double lowerBound, double upperBound) {
        this(name, defaultValue, Double.class);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public PDFCProperty(String name, boolean defaultValue) {
        this(name, defaultValue, Boolean.class);
    }

    public PDFCProperty(String name, String defaultValue, String ... validValues) {
        this(name, defaultValue, String.class);
        this.validValues = validValues;
    }

    @SafeVarargs
    public <D extends Enum<?>> PDFCProperty(String name, Class<T> validValues, D ... defaultValue) {
        this(name, (Enum)((Object)PDFCProperty.toPropertyValue(defaultValue)), Enum.class);
        this.validValues = validValues.getEnumConstants();
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    public static PDFCProperty<?> valueOf(String name) {
        PDFCProperty<?> property = PROPERTIES.get(name);
        if (property == null) {
            property = DEPRECATED.get(name);
        }
        return property;
    }

    public static Collection<PDFCProperty<?>> values() {
        return PROPERTIES.values();
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Pair<Number> getLimits() {
        if (this.type == Integer.class || this.type == Double.class) {
            return new Pair<Number>(this.lowerBound, this.upperBound);
        }
        return null;
    }

    public Object[] getValidValues() {
        return this.validValues;
    }

    public static String toPropertyValue(Object[] choice) {
        if (choice == null || choice.length == 0) {
            return "";
        }
        return Arrays.toString(choice).replaceAll("\\[|\\]", "");
    }

    public static Object[] getSelectedValues(IProfile config, PDFCProperty<?> property) {
        if (property.type == Enum.class) {
            String value = config.getString(property);
            if (value == null || value.length() == 0) {
                return new Object[0];
            }
            ArrayList<String> selected = new ArrayList<String>();
            block0: for (String entry : value.split("\\s*[,;]\\s*")) {
                entry = entry.trim();
                for (Object valid : property.validValues) {
                    if (!valid.toString().equalsIgnoreCase(entry)) continue;
                    selected.add(entry);
                    continue block0;
                }
            }
            return selected.toArray();
        }
        return null;
    }

    static {
        DEPRECATED.put("MODULES", null);
        DEPRECATED.put("NORMALIZERS", null);
        DEPRECATED.put("CONTINUOUS_FILTERS", null);
        DEPRECATED.put("CONTINUOUS_COMPARE_TYPES", null);
        DEPRECATED.put("INVISIBLEELEMENTS_HIDE_ROTATION", null);
        CREATE_DIFFIMAGES = new PDFCProperty("CREATE_DIFFIMAGES", "false", "false", "first", "second", "true");
        CREATE_XORIMAGES = new PDFCProperty("CREATE_XORIMAGES", false);
        CREATE_ORIGIMAGES = new PDFCProperty("CREATE_ORIGIMAGES", false);
        IMAGE_SCALE_FACTOR = new PDFCProperty("IMAGE_SCALE_FACTOR", 1.0, 0.1, 100.0);
        LOG_LEVEL = new PDFCProperty("LOG_LEVEL", "INFO", "OFF", "ERROR", "WARN", "INFO", "ALL");
        LOG_FILE = new PDFCProperty("LOG_FILE", "", new String[0]);
        MAX_ERRORS_PER_FILE = new PDFCProperty("MAX_ERRORS_PER_FILE", 100, -1, Integer.MAX_VALUE);
        MODULES = new PDFCProperty("MODULES", ModuleType.class, (Enum[])new ModuleType[]{ModuleType.MODULE_IMAGE, ModuleType.MODULE_PAGEPROPERTIES, ModuleType.MODULE_LINES, ModuleType.MODULE_TEXT_WORDORDER});
        NORMALIZERS = new PDFCProperty("NORMALIZERS", NormalizerType.class, (Enum[])new NormalizerType[]{NormalizerType.NORMALIZER_MARGIN});
        TOLERANCE_BOX_ROUND_EDGES = new PDFCProperty("TOLERANCE_BOX_ROUND_EDGES", 3, 0, 10);
        TOLERANCE_IMAGE_DISTANCE = new PDFCProperty("TOLERANCE_IMAGE_DISTANCE", 3, 0, 10);
        TOLERANCE_IMAGE_PIXEL_VALUE = new PDFCProperty("TOLERANCE_IMAGE_PIXEL_VALUE", 0.05, 0.0, 1.0);
        TOLERANCE_IMAGE_SIZE = new PDFCProperty("TOLERANCE_IMAGE_SIZE", 0.1, 0.0, 1.0);
        TOLERANCE_LINE_POSITION = new PDFCProperty("TOLERANCE_LINE_POSITION", 3, 0, 100);
        TOLERANCE_LINE_SIZE = new PDFCProperty("TOLERANCE_LINE_SIZE", 2, 0, 100);
        TOLERANCE_LINE_STYLE = new PDFCProperty("TOLERANCE_LINE_STYLE", false);
        TOLERANCE_LINE_THICKNESS = new PDFCProperty("TOLERANCE_LINE_THICKNESS", 1, 0, 100);
        TOLERANCE_PAGE_LEFTCORNER = new PDFCProperty("TOLERANCE_PAGE_LEFTCORNER", 3, 0, 100);
        TOLERANCE_PAGE_RATIO = new PDFCProperty("TOLERANCE_PAGE_RATIO", 0.01, 0.0, 1.0);
        TOLERANCE_PAGE_SIZE = new PDFCProperty("TOLERANCE_PAGE_SIZE", 2, 0, 100);
        TOLERANCE_UNDERLINE_LENGTH = new PDFCProperty("TOLERANCE_UNDERLINE_LENGTH", 0.1, 0.0, 10.0);
        TOLERANCE_TEXT_LOCATION = new PDFCProperty("TOLERANCE_TEXT_LOCATION", -1, -1, 100);
        TOLERANCE_TEXT_SIZE = new PDFCProperty("TOLERANCE_TEXT_SIZE", 0.05, 0.0, 1.0);
        TOLERANCE_COLOR = new PDFCProperty("TOLERANCE_COLOR", 0.01, 0.0, 1.0);
        COMPARE_TEXT_STYLES = new PDFCProperty("COMPARE_TEXT_STYLES", TextStyleType.class, (Enum[])TextStyleType.values());
        TEXT_ALIGN_RATIO = new PDFCProperty("TEXT_ALIGN_RATIO", 0.15, 0.0, 1.0);
        COMPARE_TEXT_CASE_SENSITIVE = new PDFCProperty("COMPARE_TEXT_CASE_SENSITIVE", true);
        COMPARE_LINE_STYLES = new PDFCProperty("COMPARE_LINE_STYLES", true);
        USE_PIXEL_MEDIUM_VALUE = new PDFCProperty("USE_PIXEL_MEDIUM_VALUE", true);
        FIXED_HEADER_SIZE = new PDFCProperty("FIXED_HEADER_SIZE", -1, -1, Integer.MAX_VALUE);
        FIXED_FOOTER_SIZE = new PDFCProperty("FIXED_FOOTER_SIZE", -1, -1, Integer.MAX_VALUE);
        CONTINUOUS_FILTERS = new PDFCProperty("CONTINUOUS_FILTERS", FilterType.class, (Enum[])new FilterType[]{FilterType.INVISIBLEELEMENTS});
        FILTERS = new PDFCProperty<String>("FILTERS", FilterType.INVISIBLEELEMENTS.name() + ",TEXTTRANSFORM,SOLVEFALSEREPLACE", String.class);
        CONTINUOUS_COMPARE_TYPES = new PDFCProperty("CONTINUOUS_COMPARE_TYPES", CompareType.class, (Enum[])new CompareType[]{CompareType.TEXT, CompareType.LINE, CompareType.IMAGE});
        COMPARE_TYPES = new PDFCProperty("COMPARE_TYPES", CompareType.class, (Enum[])new CompareType[]{CompareType.TEXT, CompareType.LINE, CompareType.IMAGE});
        CONTINUOUS_DETECT_PAGES = new PDFCProperty("CONTINUOUS_DETECT_PAGES", 5, -1, Integer.MAX_VALUE);
        CONTINUOUS_COMPARE = new PDFCProperty("CONTINUOUS_COMPARE", "CONTINUOUS", "CONTINUOUS", "STRICT");
        EXPORT_PDF_ALWAYS = new PDFCProperty("EXPORT_PDF_ALWAYS", false);
        FILTER_PATTERNS = new PDFCProperty("FILTER_PATTERNS", "", new String[0]);
        INVISIBLEELEMENTS_HIDE_ROTATION = new PDFCProperty("INVISIBLEELEMENTS_HIDE_ROTATION", false);
    }
}

