/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class UTF8StreamWriter
extends Writer {
    private final OutputStream output;
    private int surrogate;

    public UTF8StreamWriter(OutputStream output) {
        this.output = output;
    }

    private void writeCharUtf8(int c) throws IOException {
        if (c < 128) {
            this.output.write(c);
        } else if (c < 2048) {
            this.output.write(0xC0 | c >> 6);
            this.output.write(0x80 | c & 0x3F);
        } else if (c < 65536) {
            this.output.write(0xE0 | c >> 12);
            this.output.write(0x80 | c >> 6 & 0x3F);
            this.output.write(0x80 | c & 0x3F);
        } else {
            this.output.write(0xF0 | c >> 18 & 7);
            this.output.write(0x80 | c >> 12 & 0x3F);
            this.output.write(0x80 | c >> 6 & 0x3F);
            this.output.write(0x80 | c & 0x3F);
        }
    }

    @Override
    public void write(int ch) throws IOException {
        if (this.surrogate != 0) {
            if (Character.isLowSurrogate((char)ch)) {
                ch = ((this.surrogate & 0x3FF) << 10 | ch & 0x3FF) + 65536;
            } else {
                this.writeCharUtf8(this.surrogate);
            }
            this.surrogate = 0;
            this.writeCharUtf8(ch);
        } else if (Character.isHighSurrogate((char)ch)) {
            this.surrogate = ch;
        } else {
            this.writeCharUtf8((char)ch);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int end = off + len;
        while (off < end) {
            this.write(cbuf[off++]);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int end = off + len;
        while (off < end) {
            this.write(str.charAt(off++));
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushSurrogate();
        this.output.flush();
    }

    public void flushSurrogate() throws IOException {
        if (this.surrogate != 0) {
            this.writeCharUtf8(this.surrogate);
            this.surrogate = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.flushSurrogate();
        this.output.close();
    }
}

