/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.textselection;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.textselection.TextInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonData
@InternalApi
public class TextInfoImpl
extends DrawableElement
implements Serializable,
TextInfo {
    private String text;
    private float scale = 1.0f;
    private float x;
    private float y;
    private float height;
    private float[] charWidth;
    private float rotation;
    private int pageOffset;
    private boolean left;
    private short wswidth;
    private String fontname;
    private String fontFamily;
    private double fontSize;
    private int fontStyle;
    private String fontColor;

    protected TextInfoImpl(String text, boolean left, int pageIndex, ElementID id) {
        super(pageIndex, id);
        this.text = text;
        this.left = left;
    }

    protected TextInfoImpl() {
        super(0, ElementID.DUMMY);
    }

    protected TextInfoImpl(TextInfoImpl info) {
        this(info.text, info.left, info.getPageIndex(), info.getElementID());
        this.scale = info.scale;
        this.x = info.x;
        this.y = info.y;
        this.height = info.height;
        this.charWidth = info.charWidth;
        this.rotation = info.rotation;
        this.pageOffset = info.pageOffset;
        this.wswidth = info.wswidth;
        this.fontSize = info.fontSize;
        this.fontStyle = info.fontStyle;
        this.fontFamily = info.fontFamily;
        this.fontname = info.fontname;
        this.fontColor = info.fontColor;
    }

    public void setPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
    }

    @Override
    public List<Rectangle2D> getAreas() {
        ArrayList<Rectangle2D> shapes = new ArrayList<Rectangle2D>();
        for (int i = 0; i < this.charWidth.length; ++i) {
            shapes.add(this.getShape(i, i));
        }
        return shapes;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y + (float)this.pageOffset;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public boolean isLeft() {
        return this.left;
    }

    @Override
    public String getLabel() {
        return this.text;
    }

    @Override
    public void setX(double x) {
        this.x = (float)x;
    }

    @Override
    public void setY(double y) {
        if (y > (double)this.pageOffset) {
            y -= (double)this.pageOffset;
        }
        this.y = (float)y;
    }

    @Override
    public int getCompareHash() {
        return this.text.hashCode();
    }

    @Override
    public double getRotation() {
        return this.rotation;
    }

    @Override
    public int getWhiteSpaceWidth() {
        if (this.wswidth == 0) {
            this.wswidth = (short)(this.height / 4.0f * 20.0f);
        }
        return (int)((float)this.wswidth * this.getScale());
    }

    @Override
    public Rectangle2D getBounds() {
        return this.getShape(0, this.charWidth.length - 1);
    }

    protected Rectangle2D getShape(int start, int end) {
        float width;
        int i;
        if (start < 0 || end < start || this.charWidth.length <= end) {
            return null;
        }
        float startX = 0.0f;
        if (start > 0) {
            for (i = 0; i < start; ++i) {
                startX += this.charWidth[i];
            }
        }
        if (end > start) {
            width = 0.0f;
            for (i = start; i <= end; ++i) {
                width += this.charWidth[i];
            }
        } else {
            width = this.charWidth[start];
        }
        if ((double)this.rotation != 0.0) {
            Rectangle2D.Float tb = new Rectangle2D.Float(0.0f, 0.0f, width * this.getScale(), this.height * this.getScale());
            AffineTransform rotateInstance = AffineTransform.getRotateInstance(-this.rotation);
            AffineTransform translateInstance = AffineTransform.getTranslateInstance((this.x + startX) * this.getScale(), (this.y + (float)this.pageOffset) * this.getScale());
            return translateInstance.createTransformedShape(rotateInstance.createTransformedShape(tb)).getBounds();
        }
        return new Rectangle2D.Float((this.x + startX) * this.getScale(), (this.y + (float)this.pageOffset) * this.getScale(), width * this.getScale(), this.height * this.getScale());
    }

    @Override
    public void setScale(double scale) {
        this.scale = (float)scale;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public ElementType getType() {
        return ElementType.TextInfo;
    }

    protected void setHeight(float height) {
        this.height = height;
    }

    protected void setCharWidth(float[] charWidth) {
        this.charWidth = charWidth;
    }

    @Override
    public float[] getCharWidth() {
        return this.charWidth;
    }

    public void setColor(Color color) {
        this.fontColor = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public String getColor() {
        return this.fontColor;
    }

    public Font getFont() {
        return new Font(this.fontname, this.fontStyle, (int)Math.round(this.fontSize));
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public String getFontname() {
        return this.fontname;
    }

    public void setFontname(String fontname) {
        this.fontname = fontname;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    protected void setWswidth(short wswidth) {
        this.wswidth = wswidth;
    }

    protected void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("0.00");
        String x = df.format(this.getBounds().getX());
        String y = df.format(this.getBounds().getY());
        String height = df.format(this.getBounds().getHeight());
        String width = df.format(this.getBounds().getWidth());
        return "TI \"" + this.getLabel() + "\" (" + x + " , " + y + " , " + width + " , " + height + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextInfoImpl textInfo = (TextInfoImpl)o;
        return Float.compare(textInfo.x, this.x) == 0 && Float.compare(textInfo.y, this.y) == 0 && Float.compare(textInfo.height, this.height) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.height));
    }
}

