/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.model.text.TextStyle;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.FontInfo;
import com.inet.pdfc.model.Visitable;
import com.inet.pdfc.model.Visitor;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.annotation.Nonnull;

@InternalApi
public class TextElement
extends DrawableElement
implements Visitable {
    static final long serialVersionUID = 999238012010077L;
    private final double TWIPS = 20.0;
    private String text;
    private static double[] DEFAULT_ROTATION = new double[2];
    private double[] m = null;
    private double[] charWidths;
    private double[] kerning;
    private Rectangle2D clip;
    private double textWidth = -1.0;
    private Rectangle2D.Double bounds;
    private boolean hasUnicodeMapping = true;
    private int border = 0;
    private boolean isIndex = false;
    private boolean wsWidthArtificial;
    private final int CHECKTEXTHEIGHT = 100;
    private TextStyle style;

    private TextElement(int pageNr, ElementID id) {
        super(pageNr, id);
    }

    public TextElement(FontInfo fontInfo, float fontSize, AffineTransform transform, String text, Paint fillPaint, Paint strokePaint, double[] charWidths, double[] kerning, boolean replaceZeroChar, ElementID id) {
        this(fontInfo, fontSize, transform, text, fillPaint, strokePaint, charWidths, kerning, replaceZeroChar, true, id);
    }

    public TextElement(FontInfo fontInfo, float fontSize, AffineTransform transform, String text, Paint fillPaint, Paint strokePaint, double[] charWidths, double[] kerning, boolean replaceZeroChar, boolean hasUnicodeMapping, ElementID id) {
        super(0, id);
        double slope;
        this.hasUnicodeMapping = hasUnicodeMapping;
        this.text = text;
        this.charWidths = charWidths != null ? (double[])charWidths.clone() : new double[]{};
        this.kerning = kerning != null ? (double[])kerning.clone() : null;
        this.m = new double[6];
        this.style = new TextStyle(fontInfo, fontSize, fillPaint, strokePaint);
        this.style.setTextHeight(Math.ceil(fontInfo.getAscend(1) * (float)((int)((double)fontSize * 20.0))) / 20.0);
        transform.getMatrix(this.m);
        double[] rs = TextElement.getRotationAndShearAngle(transform);
        this.style.setRotation(rs[0]);
        this.style.setSlope(rs[1]);
        if (Math.abs(this.style.getTextHeight()) > 100.0) {
            this.style.setTextHeight(fontInfo.getMetrics((int)fontSize).getStringBounds(text, null).getBounds2D().getHeight());
        }
        boolean bl = this.wsWidthArtificial = !fontInfo.hasWhiteSpace();
        if (this.style.getWsWidth() <= 0.0) {
            this.style.setWsWidth(this.style.getTextHeight() * 0.25);
            if (this.style.getWsWidth() <= 0.0) {
                this.style.setWsWidth(Math.abs(this.style.getWsWidth()));
            }
        }
        if (transform.isIdentity()) {
            this.style.setWsWidthScaled(this.style.getWsWidth());
            this.style.setFontSize(fontSize);
        } else {
            double factor = Math.sqrt(transform.getScaleX() * transform.getScaleX() + transform.getShearY() * transform.getShearY());
            this.style.setWsWidthScaled((int)Math.round(this.style.getWsWidth() * factor));
            this.style.setFontSize((float)((double)fontSize * factor));
            if (this.style.getWsWidthScaled() <= 0.0) {
                this.style.setWsWidthScaled(this.style.getWsWidth() * factor);
            }
        }
        this.calculateBounds(transform, this.getTextWidth(), this.getTextHeight());
        double estimatedSlope = this.style.getSlope();
        if (estimatedSlope != 0.0 && estimatedSlope != Math.PI && (slope = Math.abs(estimatedSlope > 1.5707963267948966 ? estimatedSlope - Math.PI : estimatedSlope)) > 0.05 && slope < 0.7853981633974483) {
            this.style.setItalic();
        }
    }

    public double getScale() {
        return Math.sqrt(this.m[0] * this.m[0] + this.m[1] * this.m[1]);
    }

    public TextElement subText(int startIndex, int endIndex) {
        double[] partCharWidths = new double[endIndex - startIndex];
        System.arraycopy(this.getCharacterWidths(), startIndex, partCharWidths, 0, endIndex - startIndex);
        double[] partKerning = null;
        double offset = 0.0;
        if (this.getKerningArray() != null) {
            partKerning = new double[endIndex - startIndex];
            System.arraycopy(this.getKerningArray(), startIndex, partKerning, 0, endIndex - startIndex);
            partCharWidths[0] = partCharWidths[0] - partKerning[0];
            offset += partKerning[0];
            partKerning[0] = 0.0;
        }
        for (int i = 0; i < startIndex; ++i) {
            offset += this.charWidths[i];
        }
        AffineTransform transform = new AffineTransform(this.getTransformMatrix());
        transform.translate(offset, 0.0);
        TextElement part = new TextElement(this.getPageIndex(), this.getElementID().getDescendant(startIndex));
        part.charWidths = partCharWidths;
        part.kerning = partKerning;
        part.text = this.getText().substring(startIndex, endIndex);
        part.style = this.getStyle();
        part.clip = this.getClip();
        part.hasUnicodeMapping = this.hasUnicodeMapping;
        part.border = this.getBorder();
        part.isIndex = this.isIndex();
        part.m = new double[6];
        transform.getMatrix(part.m);
        part.calculateBounds(transform, part.getTextWidth(), part.getTextHeight());
        return part;
    }

    public void append(@Nonnull TextElement element) {
        this.text = this.text + element.text;
        int thisLength = this.charWidths.length;
        double[] cwTemp = new double[thisLength + element.charWidths.length];
        System.arraycopy(this.charWidths, 0, cwTemp, 0, thisLength);
        System.arraycopy(element.charWidths, 0, cwTemp, thisLength, element.charWidths.length);
        this.charWidths = cwTemp;
        if (this.kerning != null || element.kerning != null) {
            double[] tempKerning = new double[this.charWidths.length];
            if (this.kerning != null) {
                System.arraycopy(this.kerning, 0, tempKerning, 0, this.kerning.length);
            }
            if (element.kerning != null) {
                System.arraycopy(element.kerning, 0, tempKerning, thisLength, element.kerning.length);
            }
            this.kerning = tempKerning;
        }
        if (this.clip != null && element.clip != null) {
            Rectangle2D.union(this.clip, element.clip, this.clip);
        } else {
            this.clip = null;
        }
        this.textWidth = -1.0;
        this.hasUnicodeMapping |= element.hasUnicodeMapping;
        this.border = 0;
        this.isIndex &= element.isIndex;
        this.wsWidthArtificial &= element.wsWidthArtificial;
        this.calculateBounds(new AffineTransform(this.m), this.getTextWidth(), this.getTextHeight());
    }

    private static double[] getRotationAndShearAngle(AffineTransform t) {
        if (t.getShearX() == -t.getShearY() && Math.abs(t.getScaleX()) == Math.abs(t.getScaleY())) {
            if (t.getShearX() == 0.0 && t.getScaleX() > 0.0) {
                return DEFAULT_ROTATION;
            }
            return new double[]{Math.atan2(t.getShearY(), t.getScaleX()), 0.0};
        }
        double[] m = new double[4];
        t.getMatrix(m);
        t = new AffineTransform(m);
        Point2D.Double p = new Point2D.Double(1.0, 0.0);
        t.transform(p, p);
        double rotation = Math.atan2(p.getY(), p.getX());
        p = new Point2D.Double(0.0, 1.0);
        t.transform(p, p);
        double shear = 1.5707963267948966 + rotation - Math.atan2(p.getY(), p.getX());
        return new double[]{rotation, shear};
    }

    public void calculateBounds(AffineTransform transform, double textWidth, double textHeight) {
        float kerningOffset = 0.0f;
        if (this.kerning != null && this.kerning.length > 1) {
            double position = 0.0;
            kerningOffset = (float)this.kerning[0];
            int limit = Math.min(this.kerning.length, 4);
            for (int i = 0; i < limit - 1; ++i) {
                kerningOffset = (float)Math.min((double)kerningOffset, (position += this.charWidths[i]) + this.kerning[i + 1]);
            }
            if (kerningOffset >= 0.0f) {
                kerningOffset = 0.0f;
            } else {
                textWidth -= (double)kerningOffset;
            }
        }
        if (transform.getScaleX() == 1.0 && transform.getShearX() == 0.0 && transform.getScaleY() == -1.0 && transform.getShearY() == 0.0) {
            this.bounds = new Rectangle2D.Double(transform.getTranslateX() + (double)kerningOffset, transform.getTranslateY(), textWidth, -textHeight);
        } else {
            Rectangle2D.Double rect = new Rectangle2D.Double(kerningOffset, textHeight, textWidth, -textHeight);
            Point2D.Double p = new Point2D.Double();
            transform.transform(new Point2D.Double(rect.x, rect.y), p);
            this.bounds = new Rectangle2D.Double(p.x, p.y, 0.0, 0.0);
            this.bounds.add(transform.transform(new Point2D.Double(rect.x + rect.width, rect.y), p));
            this.bounds.add(transform.transform(new Point2D.Double(rect.x + rect.width, rect.y + rect.height), p));
            this.bounds.add(transform.transform(new Point2D.Double(rect.x, rect.y + rect.height), p));
            if (Math.abs(transform.getTranslateY() - this.bounds.getY()) > 0.5) {
                this.bounds = new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY() + this.bounds.getHeight(), this.bounds.getWidth(), -this.bounds.getHeight());
            }
        }
    }

    public static Rectangle2D.Double createTransformedBounds(AffineTransform at, Rectangle2D.Double rect) {
        Point2D.Double p = new Point2D.Double();
        at.transform(new Point2D.Double(rect.x, rect.y), p);
        Rectangle2D.Double bounds = new Rectangle2D.Double(p.x, p.y, 0.0, 0.0);
        bounds.add(at.transform(new Point2D.Double(rect.x + rect.width, rect.y), p));
        bounds.add(at.transform(new Point2D.Double(rect.x + rect.width, rect.y + rect.height), p));
        bounds.add(at.transform(new Point2D.Double(rect.x, rect.y + rect.height), p));
        return bounds;
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public boolean hasUnicodeMapping() {
        return this.hasUnicodeMapping;
    }

    public void setUnicodeMapping(boolean hasUnicodeMapping) {
        this.hasUnicodeMapping = hasUnicodeMapping;
    }

    public int getWhitespaceWidth() {
        return (int)this.style.getWsWidth();
    }

    public int getWhitespaceWidthScaled() {
        return (int)this.style.getWsWidthScaled();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getTextSlope() {
        return this.style.getSlope();
    }

    public FontInfo getFontInfo() {
        return this.style.getFont();
    }

    public double getTextHeight() {
        return this.style.getTextHeight();
    }

    public double[] getCharacterWidths() {
        int length = this.getText().length();
        if (this.charWidths.length > length) {
            double[] tmp = new double[length];
            System.arraycopy(this.charWidths, 0, tmp, 0, length);
            this.charWidths = tmp;
        }
        return this.charWidths;
    }

    public double getTextWidth() {
        if (this.textWidth == -1.0) {
            this.textWidth = 0.0;
            for (int i = 0; i < this.charWidths.length; ++i) {
                this.textWidth += this.charWidths[i];
            }
        }
        return this.textWidth;
    }

    public double[] getKerningArray() {
        return this.kerning;
    }

    public void setKerning(double[] kerning) {
        this.kerning = kerning;
    }

    public void setCharWidths(double[] charWidths) {
        this.charWidths = charWidths;
        this.textWidth = -1.0;
    }

    public Rectangle2D getClip() {
        return this.clip;
    }

    public void setClip(Rectangle2D clip) {
        this.clip = clip;
    }

    public double[] getTransformMatrix() {
        return this.m;
    }

    public void setBorder(int border) {
        if (border < 0 || border > 15) {
            return;
        }
        this.border = border;
    }

    public int getBorder() {
        return this.border;
    }

    public boolean hasBorder() {
        return this.border > 0;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public double getX() {
        return this.bounds.getX();
    }

    @Override
    public double getY() {
        return this.bounds.getY();
    }

    @Override
    public void setX(double x) {
        double diff = x - this.bounds.getX();
        this.bounds.setRect(x, this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
        this.m[4] = this.m[4] + diff;
        if (this.clip != null) {
            this.clip = new Rectangle2D.Double(this.clip.getX() + diff, this.clip.getY(), this.clip.getWidth(), this.clip.getHeight());
        }
    }

    @Override
    public void setY(double y) {
        double diff = y - this.bounds.getY();
        this.bounds.setRect(this.bounds.getX(), y, this.bounds.getWidth(), this.bounds.getHeight());
        this.m[5] = this.m[5] + diff;
        if (this.clip != null) {
            this.clip = new Rectangle2D.Double(this.clip.getX(), this.clip.getY() + diff, this.clip.getWidth(), this.clip.getHeight());
        }
    }

    public String toString() {
        return "\"" + this.text + "\" (" + this.bounds.getX() + "," + this.bounds.getY() + "," + this.bounds.getWidth() + "," + this.bounds.getHeight() + ")";
    }

    public float getFontSize() {
        return this.style.getFontSize();
    }

    @Override
    public int getCompareHash() {
        return this.text.hashCode();
    }

    @Override
    public double getRotation() {
        return this.style.getRotation();
    }

    public int getStyleOverride() {
        return this.style.getStyle();
    }

    @Override
    public ElementType getType() {
        return ElementType.Text;
    }

    @Override
    public Paint getStrokePaint() {
        return this.style.getStrokePaint();
    }

    @Override
    public Paint getFillPaint() {
        return this.style.getFillPaint();
    }

    public void setIndex(boolean isIndex) {
        this.isIndex = isIndex;
    }

    public boolean isIndex() {
        return this.isIndex;
    }

    public void setTextHeight(double textHeight) {
        this.style.setTextHeight(textHeight);
    }

    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds instanceof Rectangle2D.Double ? (Rectangle2D.Double)bounds : new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public String getLabel() {
        return this.text;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public boolean hasArtificialWhiteSpace() {
        return this.wsWidthArtificial;
    }

    public void setTransformMatrix(double[] newMatrix) {
        this.m = newMatrix;
    }

    public void overrideWhiteSpaceWidth(double newValue) {
        this.style.setWsWidth((int)newValue);
        if (this.m[0] != 1.0 || this.m[1] != 1.0) {
            double factor = Math.sqrt(this.m[0] * this.m[0] + this.m[1] * this.m[1]);
            this.style.setWsWidthScaled((int)Math.round(this.style.getWsWidth() * factor));
        } else {
            this.style.setWsWidthScaled(this.style.getWsWidth());
        }
    }
}

