/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.model.HasCustomData;
import com.inet.pdfc.model.AdditionalBoundsInfo;
import com.inet.pdfc.model.DrawableElementXY;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.HasAdditionalBounds;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.model.PagedElement;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@InternalApi
public class AnnotationElement
extends DrawableElementXY
implements HasCustomData,
HasAdditionalBounds {
    public static final String COMMENT_PREFIX = "Comment: ";
    public static final String SUBTYPE_COMMENT = "Comment";
    public static final String SUBTYPE_LINK = "Link";
    public static final String KEY_COMMENT = "Comment";
    public static final String KEY_LINK = "Link";
    private String subtype = SUBTYPE.Unknown.name();
    private SUBTYPE subtypeEnum = SUBTYPE.Unknown;
    private Rectangle2D bounds;
    private String contents;
    private Color color;
    private double opacity;
    private String author;
    private String subject;
    private Date creationDate;
    private STATE state;
    private STATE_MODEL stateModel;
    private int reviewID;
    private int replyToReviewID;
    private ACTION_TYPE actionType;
    private String actionTarget;
    private List<AdditionalBoundsInfo> additionalBounds;

    public AnnotationElement(int pageIndex, ElementID id) {
        super(pageIndex, id);
    }

    public String getAuthor() {
        return this.author;
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public STATE getReviewState() {
        return this.state;
    }

    public STATE_MODEL getReviewStateModel() {
        return this.stateModel;
    }

    public int getID() {
        return this.reviewID;
    }

    public int getReplyToID() {
        return this.replyToReviewID;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public SUBTYPE getSubtypeEnum() {
        return this.subtypeEnum;
    }

    public boolean isLink() {
        return this.subtypeEnum == SUBTYPE.Link && this.actionTarget != null && !this.actionTarget.isEmpty();
    }

    public boolean isLinkedToText() {
        switch (this.subtypeEnum) {
            case Link: 
            case Highlight: 
            case Underline: 
            case StrikeOut: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getLabel() {
        return this.subtypeEnum != null ? this.subtypeEnum.name() : SUBTYPE.Unknown.name();
    }

    @Override
    public Map<String, String> getCustomData() {
        Map<String, String> data = null;
        if (this.actionTarget != null) {
            data = this.addToMap("Link", this.actionTarget, data);
        }
        if (this.contents != null) {
            data = this.addToMap("Comment", this.contents, data);
        }
        return data;
    }

    private Map<String, String> addToMap(String key, String value, Map<String, String> map) {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put(key, value);
        return map;
    }

    public String getContents() {
        return this.contents;
    }

    @Override
    public ElementType getType() {
        return ElementType.Annotation;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public double getX() {
        return this.bounds != null ? this.bounds.getX() : 0.0;
    }

    @Override
    public double getY() {
        return this.bounds != null ? this.bounds.getY() : 0.0;
    }

    @Override
    public int getCompareHash() {
        return 4711 + this.subtypeEnum.ordinal();
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
        this.subtypeEnum = SUBTYPE.of(subtype);
    }

    public void setBounds(Rectangle2D bounds) {
        this.bounds = this.invertBounds() && bounds.getHeight() > 0.0 ? new Rectangle2D.Double(bounds.getX(), bounds.getMaxY(), bounds.getWidth(), -bounds.getHeight()) : bounds;
    }

    private boolean invertBounds() {
        switch (this.subtypeEnum) {
            case Link: 
            case Highlight: 
            case Underline: 
            case StrikeOut: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setX(double x) {
        if (this.additionalBounds != null) {
            double diff = x - this.bounds.getX();
            for (AdditionalBoundsInfo b : this.additionalBounds) {
                b.move(diff, 0.0);
            }
        }
        this.bounds = new Rectangle2D.Double(x, this.bounds.getMinY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    @Override
    public void setY(double y) {
        if (this.additionalBounds != null) {
            double diff = y - this.getY();
            for (AdditionalBoundsInfo b : this.additionalBounds) {
                b.move(0.0, diff);
            }
        }
        this.bounds = new Rectangle2D.Double(this.bounds.getMinX(), y, this.bounds.getWidth(), this.bounds.getHeight());
    }

    protected void setContents(String contents) {
        this.contents = contents;
    }

    protected void setColor(Color color) {
        this.color = color;
    }

    protected void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    protected void setAuthor(String author) {
        this.author = author;
    }

    protected void setSubject(String subject) {
        this.subject = subject;
    }

    protected void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    protected void setState(STATE state) {
        this.state = state;
    }

    protected void setStateModel(STATE_MODEL stateModel) {
        this.stateModel = stateModel;
    }

    protected void setReviewID(int reviewID) {
        this.reviewID = reviewID;
    }

    protected void setReplyToReviewID(int replyToReviewID) {
        this.replyToReviewID = replyToReviewID;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return "Annotation: " + this.subtype + "\n" + (String)(this.getAuthor() != null ? "Author    : " + this.getAuthor() + "\n" : "") + (String)(this.getReviewState() != null ? "State     : " + String.valueOf((Object)this.getReviewState()) + "\n" : "") + (String)(this.getReviewStateModel() != null ? "StateModel      : " + String.valueOf((Object)this.getReviewStateModel()) + "\n" : "") + (String)(this.getCreationDate() != null ? "Date      : " + String.valueOf(this.getCreationDate()) + "\n" : "") + "Opacity      : " + this.getOpacity() + "\nID      : " + this.getID() + "\nReplayID      : " + this.getReplyToID() + "\n" + (String)(this.getActionType() != null ? "ActionType      : " + String.valueOf((Object)this.getActionType()) + "\n" : "") + (String)(this.getActionTarget() != null ? "ActionTarget      : " + this.getActionTarget() + "\n" : "") + (String)(this.getColor() != null ? "Color      : " + String.valueOf(this.getColor()) + "\n" : "") + (String)(this.getContents() != null ? "Contents  : " + this.contents + "\n" : "") + (String)(this.getLabel() != null ? "Label  : " + this.getLabel() + "\n" : "") + (String)(this.getBounds() != null ? "(" + this.bounds.getX() + "," + this.bounds.getY() + "," + this.bounds.getWidth() + "," + this.bounds.getHeight() + ")" : "");
    }

    public double getOpacity() {
        return this.opacity;
    }

    public Page getAppearance() {
        return null;
    }

    public boolean hasAppearance() {
        return false;
    }

    protected void setActionType(ACTION_TYPE actionType) {
        this.actionType = actionType;
    }

    public ACTION_TYPE getActionType() {
        return this.actionType;
    }

    protected void setActionTarget(String actionTarget) {
        this.actionTarget = actionTarget;
    }

    public String getActionTarget() {
        return this.actionTarget;
    }

    @Override
    public void setAdditionalBounds(AdditionalBoundsInfo ... additionalBounds) {
        this.additionalBounds = additionalBounds != null && additionalBounds.length > 0 ? new ArrayList<AdditionalBoundsInfo>(Arrays.asList(additionalBounds)) : null;
    }

    @Override
    public List<AdditionalBoundsInfo> getAdditionalBounds() {
        return this.additionalBounds;
    }

    @Override
    public boolean hasAdditionalBounds() {
        return this.additionalBounds != null && !this.additionalBounds.isEmpty();
    }

    @Override
    public void createReplacementElements(List<PagedElement> listToAddTo) {
        if (this.additionalBounds == null || this.additionalBounds.isEmpty()) {
            return;
        }
        ElementID id = this.getElementID().getDescendant();
        for (AdditionalBoundsInfo info : this.getAdditionalBounds()) {
            AnnotationElement virtualPosition = new AnnotationElement(this.getPageIndex(), id);
            virtualPosition.setActionTarget(this.actionTarget);
            virtualPosition.setActionType(this.actionType);
            virtualPosition.setAuthor(this.author);
            virtualPosition.setColor(this.color);
            virtualPosition.setContents(this.contents);
            virtualPosition.setCreationDate(this.creationDate);
            virtualPosition.setOpacity(this.opacity);
            virtualPosition.setReplyToReviewID(this.replyToReviewID);
            virtualPosition.setReviewID(this.reviewID);
            virtualPosition.setState(this.state);
            virtualPosition.setStateModel(this.stateModel);
            virtualPosition.setSubject(this.subject);
            virtualPosition.setSubtype(this.subtype);
            virtualPosition.setBounds(info.getBounds());
            listToAddTo.add(virtualPosition);
            id = id.getNext();
        }
    }

    public static enum SUBTYPE {
        Text,
        Link,
        FreeText,
        Line,
        Square,
        Circle,
        Polygon,
        PolyLine,
        Highlight,
        Underline,
        Squiggly,
        StrikeOut,
        Stamp,
        Caret,
        Ink,
        Popup,
        FileAttachment,
        Sound,
        Movie,
        Widget,
        Screen,
        PrinterMark,
        TrapNet,
        Watermark,
        Unknown;

        private static Map<String, SUBTYPE> valueMap;

        public static SUBTYPE of(String subtype) {
            if (subtype == null) {
                return null;
            }
            SUBTYPE typeKey = valueMap.get(subtype.toLowerCase());
            return typeKey != null ? typeKey : Unknown;
        }

        static {
            valueMap = new HashMap<String, SUBTYPE>();
            for (SUBTYPE t : SUBTYPE.values()) {
                valueMap.put(t.name().toLowerCase(), t);
            }
        }
    }

    @InternalApi
    public static enum STATE {
        Marked,
        Unmarked,
        Accepted,
        Rejected,
        Cancelled,
        Completed,
        None;


        public static STATE[] getReviewStates() {
            return new STATE[]{None, Accepted, Cancelled, Completed, Rejected};
        }

        public static STATE[] getMarkedStates() {
            return new STATE[]{Marked, Unmarked};
        }
    }

    @InternalApi
    public static enum STATE_MODEL {
        Marked,
        Review;

    }

    @InternalApi
    public static enum ACTION_TYPE {
        GoTo,
        URI;

    }
}

