/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.model.ModificationFormatter;
import com.inet.pdfc.generator.model.diff.AttributeDifference;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class ModificationFormatterGUI
extends ModificationFormatter {
    private boolean merge;

    public ModificationFormatterGUI(boolean merge) {
        this.merge = merge;
    }

    @Override
    protected String getContent(List<PagedElement> elements, boolean isText, ElementType baseType) {
        String content = super.getContent(elements, isText, baseType);
        if (this.merge && content.startsWith("'") && content.endsWith("'")) {
            return content.substring(1, content.length() - 1);
        }
        return content;
    }

    @Override
    public String format(Modification m) {
        Object modifications;
        Modification.ModificationType modType;
        if (m == null) {
            return null;
        }
        if (!this.merge) {
            return super.format(m);
        }
        List<PagedElement> first = m.getAffectedElements(true);
        List<PagedElement> second = m.getAffectedElements(false);
        ElementType typeFirst = this.getBaseType(first);
        ElementType typeSecond = this.getBaseType(second);
        boolean firstIsText = this.isText(typeFirst, first);
        boolean secondIsText = this.isText(typeSecond, second);
        boolean isText = (firstIsText || secondIsText) && typeFirst != ElementType.Annotation && typeSecond != ElementType.Annotation;
        String plural = first.size() > 1 || first.size() == 0 && second.size() > 1 && !isText && !m.isShouldPageElementMerge() ? ".plural" : ".singular";
        String contentFirst = this.getDiffContent(first, typeFirst, firstIsText, true);
        String contentSecond = this.getDiffContent(second, typeSecond, secondIsText, first.isEmpty());
        AttributeDifference<?> locationChange = isText ? this.getLocationChange(m) : null;
        Modification.ModificationType modificationType = modType = locationChange != null ? Modification.ModificationType.attributeDifference : m.getModificationType();
        if (m.isShouldPageElementMerge()) {
            ArrayList<PagedElement> pagedElements;
            if (!first.isEmpty()) {
                pagedElements = new ArrayList<PagedElement>();
                pagedElements.add(first.get(0));
                contentFirst = this.getContent(pagedElements, firstIsText, typeFirst);
            }
            if (!second.isEmpty()) {
                pagedElements = new ArrayList();
                pagedElements.add(second.get(0));
                contentSecond = this.getContent(pagedElements, secondIsText, typeSecond);
            }
            return Msg.getMsg("Modification.short." + String.valueOf((Object)modType) + plural, "", contentFirst, contentSecond, "");
        }
        List<AttributeDifference<?>> changes = m.getAttributeDifferences();
        if (locationChange != null) {
            changes = new ArrayList(changes);
            changes.remove(locationChange);
            changes.add(locationChange);
            modifications = this.getModifications(changes);
            String position = this.getPosition(first, second);
            modifications = (String)modifications + position;
        } else {
            modifications = this.getModifications(changes);
        }
        if (changes != null && !changes.isEmpty()) {
            return modifications;
        }
        return Msg.getMsg("Modification.short." + String.valueOf((Object)modType) + plural, contentFirst, contentSecond, modifications).trim();
    }

    private String getDiffContent(List<PagedElement> elements, ElementType baseType, boolean isText, boolean firstInLabel) {
        Object content;
        if (isText) {
            if (baseType != ElementType.Annotation) {
                content = this.getContent(elements, true, baseType);
            } else {
                content = this.getPrefixLabel(baseType, this.getSubType(elements), elements.size(), true, firstInLabel);
                if (!((String)content).endsWith(" ")) {
                    content = (String)content + " ";
                }
                content = (String)content + (this.merge ? "'" : "") + this.getContent(elements, true, baseType) + (this.merge ? "'" : "");
            }
        } else {
            content = this.getPrefixLabel(baseType, baseType == ElementType.Annotation ? this.getSubType(elements) : null, elements.size(), true, firstInLabel);
        }
        return content;
    }
}

