/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model;

import com.inet.pdfc.generator.model.HasCustomData;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.model.diff.AttributeDifference;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.AnnotationElement;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ModificationFormatter {
    public String format(Modification m) {
        Object modifications;
        Modification.ModificationType modType;
        if (m == null) {
            return null;
        }
        List<PagedElement> first = m.getAffectedElements(true);
        List<PagedElement> second = m.getAffectedElements(false);
        ElementType typeFirst = this.getBaseType(first);
        ElementType typeSecond = this.getBaseType(second);
        boolean firstIsText = this.isText(typeFirst, first);
        boolean secondIsText = this.isText(typeSecond, second);
        boolean isText = (firstIsText || secondIsText) && typeFirst != ElementType.Annotation && typeSecond != ElementType.Annotation;
        String plural = (first.size() > 1 || first.size() == 0 && second.size() > 1) && !isText && !m.isShouldPageElementMerge() ? ".plural" : ".singular";
        List<PagedElement> refList = first.size() > 0 ? first : second;
        ElementType type = first.size() > 0 ? typeFirst : typeSecond;
        String prefix = this.getPrefixLabel(type, type == ElementType.Annotation ? this.getSubType(refList) : null, refList.size(), false, true);
        String contentFirst = this.getContent(first, isText, typeFirst);
        String contentSecond = this.getContent(second, isText, typeSecond);
        AttributeDifference<?> locationChange = isText || typeFirst == ElementType.Image && typeSecond == ElementType.Image ? this.getLocationChange(m) : null;
        Modification.ModificationType modificationType = modType = locationChange != null ? Modification.ModificationType.attributeDifference : m.getModificationType();
        if (m.isShouldPageElementMerge()) {
            ArrayList<PagedElement> pagedElements;
            if (!first.isEmpty()) {
                pagedElements = new ArrayList<PagedElement>();
                pagedElements.add(first.get(0));
                contentFirst = this.getContent(pagedElements, isText, typeFirst);
            }
            if (!second.isEmpty()) {
                pagedElements = new ArrayList();
                pagedElements.add(second.get(0));
                contentSecond = this.getContent(pagedElements, isText, typeSecond);
            }
            return Msg.getMsg("Modification." + String.valueOf((Object)modType) + plural, prefix, contentFirst, contentSecond, "");
        }
        List<AttributeDifference<?>> changes = m.getAttributeDifferences();
        if (locationChange != null) {
            changes = new ArrayList(changes);
            changes.remove(locationChange);
            changes.add(locationChange);
            modifications = this.getModifications(changes);
            String position = this.getPosition(first, second);
            modifications = (String)modifications + position;
        } else {
            modifications = this.getModifications(changes);
        }
        if (modType != Modification.ModificationType.attributeDifference && changes != null && !changes.isEmpty()) {
            return modifications;
        }
        return Msg.getMsg("Modification." + String.valueOf((Object)modType) + plural, prefix, contentFirst, contentSecond, modifications);
    }

    protected ElementType getBaseType(List<PagedElement> list) {
        ElementType type = null;
        for (PagedElement e : list) {
            ElementType eType = e.getType().getBaseType();
            if (type == null) {
                type = eType;
                continue;
            }
            if (type == eType) continue;
            return null;
        }
        return type;
    }

    protected AnnotationElement.SUBTYPE getSubType(List<PagedElement> list) {
        AnnotationElement.SUBTYPE type = null;
        for (PagedElement e : list) {
            AnnotationElement.SUBTYPE eType = AnnotationElement.SUBTYPE.of(e.getLabel());
            if (type == null) {
                type = eType;
                continue;
            }
            if (type == eType) continue;
            return null;
        }
        return type;
    }

    protected AttributeDifference<?> getLocationChange(Modification m) {
        if (m.getAttributeDifferences() != null && m.getAttributeDifferences().size() > 0) {
            for (AttributeDifference<?> d : m.getAttributeDifferences()) {
                if ("TextLocationDiff".equals(d.getClass().getSimpleName())) {
                    return d;
                }
                if (!"ImageLocationDiff".equals(d.getClass().getSimpleName())) continue;
                return d;
            }
        }
        return null;
    }

    protected String getModifications(List<AttributeDifference<?>> modificationList) {
        String modifications = "";
        if (modificationList != null && modificationList.size() > 0) {
            StringBuilder modBuilder = new StringBuilder();
            for (AttributeDifference<?> mod : modificationList) {
                if (modBuilder.length() > 0) {
                    modBuilder.append(", ");
                }
                modBuilder.append(mod.getMessage());
            }
            modifications = modBuilder.toString();
        }
        return modifications;
    }

    protected String getContent(List<PagedElement> elements, boolean isText, ElementType baseType) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        String concatString = isText ? (baseType == ElementType.Annotation ? "', '" : " ") : ", ";
        StringBuilder content = new StringBuilder();
        for (PagedElement e : elements) {
            String label;
            if (content.length() > 0) {
                content.append(concatString);
            }
            if ((label = this.getLabel(e)) == null) continue;
            content.append(label);
        }
        return content.length() > 0 ? "'" + content.toString() + "'" : "";
    }

    private String getLabel(PagedElement e) {
        String label = e.getLabel();
        if (e.getType() == ElementType.Annotation) {
            if (label != null && label.startsWith("Comment: ")) {
                label = label.substring("Comment: ".length());
            } else if (e instanceof HasCustomData) {
                Map<String, String> data = ((HasCustomData)((Object)e)).getCustomData();
                if (data == null) {
                    return label;
                }
                String key = this.getAnnotationContentKey(label);
                String content = data.get(key);
                if (content != null) {
                    return content;
                }
            }
        }
        return label;
    }

    protected boolean isText(ElementType baseType, List<PagedElement> elements) {
        if (baseType == null) {
            return false;
        }
        switch (baseType) {
            case Text: 
            case TextWord: {
                return true;
            }
            case Annotation: {
                for (PagedElement annotationElement : elements) {
                    Map<String, String> customData;
                    String label = annotationElement.getLabel();
                    if (label != null && label.startsWith("Comment: ") || annotationElement instanceof HasCustomData && (customData = ((HasCustomData)((Object)annotationElement)).getCustomData()) != null && customData.get(this.getAnnotationContentKey(label)) != null) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private String getAnnotationContentKey(String label) {
        AnnotationElement.SUBTYPE subtype = AnnotationElement.SUBTYPE.of(label);
        String key = subtype == AnnotationElement.SUBTYPE.Link ? "Link" : "Comment";
        return key;
    }

    protected String getPosition(List<PagedElement> elements, List<PagedElement> elements2) {
        if (elements == null || elements.size() == 0 || elements2 == null || elements2.size() == 0) {
            return "";
        }
        int precise = 3;
        Object concatString = " ( ";
        Rectangle2D bounds = elements.get(0).getBounds();
        BigDecimal x1 = new BigDecimal(bounds.getX());
        BigDecimal y1 = new BigDecimal(bounds.getY());
        bounds = elements2.get(0).getBounds();
        BigDecimal x2 = new BigDecimal(bounds.getX());
        BigDecimal y2 = new BigDecimal(bounds.getY());
        concatString = (String)concatString + String.valueOf(x1.setScale(precise, RoundingMode.HALF_UP)) + " : " + String.valueOf(y1.setScale(precise, RoundingMode.HALF_UP)) + " ) -> ( ";
        concatString = (String)concatString + String.valueOf(x2.setScale(precise, RoundingMode.HALF_UP)) + " : " + String.valueOf(y2.setScale(precise, RoundingMode.HALF_UP)) + " )";
        return concatString;
    }

    protected String getPrefixLabel(ElementType type, AnnotationElement.SUBTYPE subtype, int count, boolean showNumber, boolean firstInLabel) {
        String key;
        Object typeName;
        Object object = typeName = type != null ? type.name() : "Element";
        if (subtype != null) {
            typeName = (String)typeName + "." + String.valueOf((Object)subtype);
        }
        if (count > 1) {
            if (showNumber) {
                return count + " " + Msg.getMsg("Type." + (String)typeName + ".plural");
            }
            return Msg.getMsg("Prefix." + (String)typeName + ".plural");
        }
        Object label = null;
        if (!firstInLabel && Msg.hasMsg(key = "Prefix." + (String)typeName + ".singular.second")) {
            label = Msg.getMsg(key);
        }
        if (label == null) {
            label = Msg.getMsg("Prefix." + (String)typeName + ".singular");
            if (!firstInLabel && Character.isUpperCase(((String)label).charAt(0))) {
                label = Character.toLowerCase(((String)label).charAt(0)) + ((String)label).substring(1);
            }
        }
        return label;
    }
}

