/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.message;

import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.model.AnnotationElement;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.Map;

@JsonData
public class AnnotationHighlight
extends HighlightData.Highlight {
    private String author;
    private AnnotationElement.STATE state;
    private AnnotationElement.STATE_MODEL stateModel;
    private String subject;
    private int id;
    private int irtID;
    private long date;
    private boolean isVisible = true;
    private boolean isAnnotation = false;

    private AnnotationHighlight() {
    }

    public AnnotationHighlight(Rectangle bounds, AnnotationElement annotation) {
        super(bounds.x, bounds.y, bounds.width, bounds.height, AnnotationHighlight.getCaption(annotation), AnnotationHighlight.getHighlightAppearance(annotation), annotation.getColor());
        this.author = annotation.getAuthor();
        this.state = annotation.getReviewState();
        this.stateModel = annotation.getReviewStateModel();
        this.subject = annotation.getSubject();
        this.id = annotation.getID();
        this.irtID = annotation.getReplyToID();
        this.date = annotation.getCreationDate() != null ? annotation.getCreationDate().getTime() : 0L;
        this.isAnnotation = true;
    }

    private static String getCaption(AnnotationElement annotation) {
        Map<String, String> data = annotation.getCustomData();
        if (data == null) {
            return annotation.getLabel();
        }
        if (data.containsKey("Comment")) {
            return data.get("Comment");
        }
        if (data.containsKey("Link")) {
            return data.get("Link");
        }
        return annotation.getLabel();
    }

    @Override
    public String toString() {
        return "Annotation: " + this.getCaption() + "\nAuthor    : " + this.author + "\nState     : " + String.valueOf((Object)this.stateModel) + ", " + String.valueOf((Object)this.state) + "\nID        : " + this.id + "\nReplyToID : " + this.irtID;
    }

    public Date getCreationDate() {
        return new Date(this.date);
    }

    public String getAuthor() {
        return this.author;
    }

    public int getId() {
        return this.id;
    }

    public int getIrtID() {
        return this.irtID;
    }

    public AnnotationElement.STATE getState() {
        return this.state;
    }

    public AnnotationElement.STATE_MODEL getStateModel() {
        return this.stateModel;
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public final boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public static HighlightData.Highlight.Appearance getHighlightAppearance(AnnotationElement anno) {
        Rectangle2D bounds = anno.getBounds();
        if (bounds.getHeight() == 0.0 && bounds.getWidth() == 0.0) {
            return null;
        }
        switch (anno.getSubtypeEnum()) {
            case Highlight: {
                return HighlightData.Highlight.Appearance.FILLED_RECTANGLE;
            }
            case StrikeOut: {
                return HighlightData.Highlight.Appearance.STRIKEOUT;
            }
            case Underline: {
                return HighlightData.Highlight.Appearance.UNDERLINE;
            }
            case Text: 
            case FreeText: 
            case Line: 
            case Circle: 
            case Square: 
            case Polygon: 
            case PolyLine: 
            case Caret: 
            case Stamp: 
            case Ink: 
            case Squiggly: {
                return HighlightData.Highlight.Appearance.CUSTOM;
            }
        }
        return null;
    }
}

