/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mdns;

import com.inet.mdns.MDNSInputStream;
import com.inet.mdns.MDNSOutputStream;
import com.inet.mdns.Question;
import com.inet.mdns.record.Record;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Message {
    public static final int FLAGS_RESPONSE = 32768;
    public static final int FLAGS_AUTHORATIVE = 1024;
    private int id;
    private int flags;
    private List<Question> questions = new ArrayList<Question>();
    private List<Record> answers = new ArrayList<Record>();
    private List<Record> authoritativeAnswers = new ArrayList<Record>();

    public static Message fromByteArray(byte[] buf, int length) {
        Message msg = new Message();
        MDNSInputStream in = new MDNSInputStream(buf, 0, length);
        try {
            Record record;
            int i;
            msg.id = in.readUnsignedShort();
            msg.flags = in.readUnsignedShort();
            int numQuestions = in.readUnsignedShort();
            int numAnswers = in.readUnsignedShort();
            int numAuthorities = in.readUnsignedShort();
            in.readUnsignedShort();
            for (i = 0; i < numQuestions; ++i) {
                msg.questions.add(new Question(in.readName(), in.readUnsignedShort(), in.readUnsignedShort()));
            }
            for (i = 0; i < numAnswers; ++i) {
                record = Record.read(in);
                if (record == null) continue;
                msg.answers.add(record);
            }
            for (i = 0; i < numAuthorities; ++i) {
                record = Record.read(in);
                if (record == null) continue;
                msg.authoritativeAnswers.add(record);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return msg;
    }

    public byte[] toByteArray() {
        MDNSOutputStream out = new MDNSOutputStream();
        out.writeShort(this.id);
        out.writeShort(this.flags);
        out.writeShort(this.questions.size());
        out.writeShort(this.answers.size());
        out.writeShort(this.authoritativeAnswers.size());
        out.writeShort(0);
        for (Question question : this.questions) {
            question.writeTo(out);
        }
        for (Record record : this.answers) {
            record.writeTo(out);
        }
        for (Record record : this.authoritativeAnswers) {
            record.writeTo(out);
        }
        return out.toByteArray();
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String toString() {
        return "Q:" + String.valueOf(this.questions) + "   A: " + String.valueOf(this.answers) + "   AA: " + String.valueOf(this.authoritativeAnswers);
    }

    public void addQuestion(Question question) {
        this.questions.add(question);
    }

    public void addAnswer(Record record) {
        this.answers.add(record);
    }

    public void addAnswers(ArrayList<Record> records) {
        this.answers.addAll(records);
    }

    public void addAuthoriativeAnswer(Record record) {
        this.authoritativeAnswers.add(record);
    }

    public List<Question> getQuestions() {
        return this.questions;
    }

    List<Record> getAnswers() {
        return this.answers;
    }

    List<Record> getAuthoritativeAnswers() {
        return this.authoritativeAnswers;
    }
}

