/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.util;

import com.inet.error.HasErrorCode;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.i18n.Localized;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.FastStringReader;
import com.inet.lib.json.Json;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class StringFunctions {
    private static final String SPACE33 = "                                 ";
    private static final int SPACE33_LENGTH = "                                 ".length();
    private static final ThreadLocal<HashMap<Locale, Collator>> COLLATORS = new ThreadLocal();
    private static final HashMap<String, Integer> HTML_CHARS = new HashMap(0);

    private StringFunctions() {
    }

    public static final String traceToString(Throwable throwable) {
        FastByteArrayOutputStream target = new FastByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(target));
        return new String(target.toByteArray());
    }

    @Nonnull
    public static final String getUserFriendlyErrorMessage(@Nonnull Throwable th) {
        Object errormsg = th.getMessage();
        try {
            if ((th instanceof RuntimeException || th instanceof Error || th.getClass() == IOException.class) && (errormsg == null || ((String)errormsg).length() < 20)) {
                StackTraceElement stackTraceElement;
                StackTraceElement[] stackTrace;
                if (errormsg == null) {
                    errormsg = th.getClass().getSimpleName();
                }
                if ((stackTrace = th.getStackTrace()).length > 0 && (stackTraceElement = stackTrace[0]) != null) {
                    errormsg = (String)errormsg + " - at " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
                }
            }
            if (!(th instanceof RuntimeException || th instanceof HasErrorCode || th instanceof Localized || th.getClass() == IOException.class)) {
                String[] classWords = th.getClass().getSimpleName().split("(?<=[a-z])(?=[A-Z])");
                StringBuilder className = new StringBuilder();
                for (String word : classWords) {
                    if ("Exception".equals(word) || "Error".equals(word)) continue;
                    if (word.endsWith("Exception")) {
                        word = word.substring(0, word.length() - "Exception".length());
                    }
                    className.append(word).append(' ');
                }
                errormsg = className.length() == 0 ? errormsg : className.toString().trim() + ": " + (String)errormsg;
            } else if (th instanceof NumberFormatException) {
                errormsg = "Can't convert number. " + (String)errormsg;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (errormsg == null || ((String)errormsg).isEmpty()) {
            errormsg = th.toString();
        }
        return errormsg;
    }

    @Nonnull
    public static final String getUserFriendlyErrorMessage(@Nonnull Throwable th, boolean showCauses) {
        if (!showCauses) {
            return StringFunctions.getUserFriendlyErrorMessage(th);
        }
        StringBuilder msg = new StringBuilder();
        String last = null;
        while (th != null) {
            String next = StringFunctions.getUserFriendlyErrorMessage(th);
            if (!Objects.equals(last, next)) {
                if (!msg.isEmpty()) {
                    msg.append("\n- ");
                }
                msg.append(next);
            }
            last = next;
            th = th.getCause();
        }
        return msg.toString();
    }

    @Nonnull
    public static final String getUserFriendlyErrorMessage(URLConnection conn) {
        Object str;
        InputStream input;
        block20: {
            try {
                input = conn.getInputStream();
            }
            catch (IOException ex) {
                input = conn instanceof HttpURLConnection ? ((HttpURLConnection)conn).getErrorStream() : null;
                if (input != null) break block20;
                return StringFunctions.getUserFriendlyErrorMessage(ex);
            }
        }
        String contentType = conn.getContentType();
        try (Scanner scanner = new Scanner(input, StandardCharsets.UTF_8.name());){
            str = scanner.useDelimiter("\\A").next();
        }
        if (((String)str).length() > 0 && contentType != null) {
            String mimeType;
            String[] split = contentType.split(";");
            block8 : switch (mimeType = split[0].trim()) {
                case "text/html": {
                    try {
                        final StringBuilder buffer = new StringBuilder();
                        HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){
                            private boolean dontWrite;

                            @Override
                            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                                if (t == HTML.Tag.TITLE || t == HTML.Tag.STYLE) {
                                    this.dontWrite = true;
                                } else if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '\n' && (t == HTML.Tag.P || t == HTML.Tag.DIV || t == HTML.Tag.H1 || t == HTML.Tag.H2 || t == HTML.Tag.H3 || t == HTML.Tag.H4 || t == HTML.Tag.LI || t == HTML.Tag.PRE || t == HTML.Tag.UL || t == HTML.Tag.BLOCKQUOTE)) {
                                    buffer.append("\n");
                                }
                            }

                            @Override
                            public void handleEndTag(HTML.Tag t, int pos) {
                                if (t == HTML.Tag.TITLE || t == HTML.Tag.STYLE) {
                                    this.dontWrite = false;
                                }
                                if (t == HTML.Tag.P || t == HTML.Tag.DIV || t == HTML.Tag.H1 || t == HTML.Tag.H2 || t == HTML.Tag.H3 || t == HTML.Tag.H4 || t == HTML.Tag.LI || t == HTML.Tag.TR) {
                                    buffer.append('\n');
                                }
                            }

                            @Override
                            public void handleText(char[] text, int pos) {
                                if (!this.dontWrite) {
                                    buffer.append(text);
                                }
                            }
                        };
                        ParserDelegator delegator = new ParserDelegator();
                        delegator.parse(new FastStringReader((String)str), callback, Boolean.TRUE);
                        if (buffer.length() <= 0) break;
                        str = buffer.toString();
                    }
                    catch (Exception buffer) {}
                    break;
                }
                case "application/json": {
                    String[] keys;
                    HashMap<Object, Map<String, String>> extraFields = new HashMap<Object, Map<String, String>>();
                    HashMap result = (HashMap)new Json().fromJson((String)str, (Type)((Object)HashMap.class), (Map<Object, Map<String, String>>)extraFields, null);
                    for (String key : keys = new String[]{"error_description", "error", "message"}) {
                        String valStr;
                        Object val = result.get(key);
                        if (val == null || StringFunctions.isEmpty(valStr = val.toString())) continue;
                        str = valStr;
                        break block8;
                    }
                    break;
                }
            }
        }
        if (((String)str).length() > 250) {
            str = ((String)str).substring(0, 247) + "...";
        }
        return str;
    }

    @Deprecated
    public static String getHTMLEncoded(String toConvert) {
        return StringFunctions.encodeHTML(toConvert, false);
    }

    public static String encodeHTML(String text) {
        return StringFunctions.encodeHTML(text, true);
    }

    public static String encodeHTML(@Nullable String text, boolean encodeWhitespaces) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        StringBuilder result = null;
        int off = 0;
        char ch = '\u0000';
        block13: for (int i = 0; i < length; ++i) {
            char lastChar = ch;
            ch = text.charAt(i);
            switch (ch) {
                case '\n': {
                    if (encodeWhitespaces) break;
                    continue block13;
                }
                case ' ': {
                    if (encodeWhitespaces && lastChar == ' ') break;
                    continue block13;
                }
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    break;
                }
                default: {
                    continue block13;
                }
            }
            if (result == null) {
                result = new StringBuilder(length);
            }
            result.append(text, off, i);
            off = i + 1;
            switch (ch) {
                case '\"': {
                    result.append("&quot;");
                    continue block13;
                }
                case '&': {
                    result.append("&amp;");
                    continue block13;
                }
                case '<': {
                    result.append("&lt;");
                    continue block13;
                }
                case '>': {
                    result.append("&gt;");
                    continue block13;
                }
                case '\n': {
                    result.append("<BR>");
                    continue block13;
                }
                case ' ': {
                    result.append("&nbsp;");
                    ch = '\u0000';
                }
            }
        }
        if (result == null) {
            return text;
        }
        result.append(text, off, length);
        return result.toString();
    }

    public static String decodeHTML(String str) {
        StringBuilder builder = null;
        int last = 0;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            int idx;
            char ch = str.charAt(i);
            if (ch != '&' || (idx = str.indexOf(59, i)) <= 0) continue;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(str, last, i);
            last = idx + 1;
            try {
                int intVal;
                if (str.charAt(i + 1) == '#') {
                    intVal = str.charAt(i + 2) != 'x' ? Integer.parseInt(str.substring(i + 2, idx)) : Integer.parseInt(str.substring(i + 3, idx), 16);
                } else {
                    Integer value = HTML_CHARS.get(str.substring(i + 1, idx));
                    intVal = value;
                }
                builder.append((char)intVal);
            }
            catch (Exception ex) {
                builder.append(str.substring(i, ++idx));
            }
            i = idx;
        }
        if (builder != null) {
            builder.append(str, last, length);
            return builder.toString();
        }
        return str;
    }

    public static String encodeXML(String s) {
        StringBuilder encoded = null;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\u0000') continue;
            if (c < ' ' || c == '<' || c == '>' || c == '&' || c == '\"' || c == '[' || c == ']') {
                if (encoded == null) {
                    encoded = new StringBuilder().append(s, 0, i);
                }
                encoded.append("&#").append((int)c).append(";");
                continue;
            }
            if (encoded == null) continue;
            encoded.append(c);
        }
        return encoded == null ? s : encoded.toString();
    }

    public static Boolean likeCaseSensitive(String fi, String pa) {
        if (pa.length() == 0) {
            return Boolean.FALSE;
        }
        char[] search = fi.toCharArray();
        char[] mask = pa.toCharArray();
        int mIdx = 0;
        int sIdx = 0;
        boolean range = false;
        block4: while (mask.length > mIdx && search.length > sIdx) {
            char m = mask[mIdx++];
            switch (m) {
                case '*': {
                    range = true;
                    continue block4;
                }
                case '?': {
                    ++sIdx;
                    continue block4;
                }
            }
            if (range) {
                while (sIdx < search.length && search[sIdx] != m) {
                    ++sIdx;
                }
                if (sIdx >= search.length) {
                    return Boolean.FALSE;
                }
                int lastMIdx = mIdx - 1;
                int lastSIdx = ++sIdx;
                while (mask.length > mIdx && search.length > sIdx) {
                    if (search[sIdx] != (m = mask[mIdx++])) {
                        Boolean matchRight;
                        if (m == '*') {
                            --mIdx;
                            break;
                        }
                        if (m == '?' && (matchRight = StringFunctions.likeCaseSensitive(fi.substring(sIdx), pa.substring(--mIdx))).booleanValue()) {
                            return Boolean.TRUE;
                        }
                        mIdx = lastMIdx;
                        sIdx = lastSIdx;
                        continue block4;
                    }
                    ++sIdx;
                }
                if (mask.length == mIdx && search.length > sIdx) {
                    mIdx = lastMIdx;
                    sIdx = lastSIdx;
                    continue;
                }
                range = false;
                continue;
            }
            if (search[sIdx] != m) {
                return Boolean.FALSE;
            }
            ++sIdx;
        }
        while (mask.length > mIdx) {
            if (mask[mIdx++] == '*') continue;
            return Boolean.FALSE;
        }
        if (search.length > sIdx && !range) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static String numberToRomanNumerals(long n) {
        if (n <= 0L) {
            return String.valueOf(0);
        }
        StringBuilder result = new StringBuilder();
        NumSet[] symbols = NumSet.values();
        for (int i = symbols.length - 1; i >= 0; --i) {
            while (n >= (long)symbols[i].value) {
                result.append((Object)symbols[i]);
                n -= (long)symbols[i].value;
            }
        }
        return result.toString();
    }

    public static String numberToAlphabetic(int num) {
        StringBuilder result = new StringBuilder();
        while (num > 0) {
            int remainder = --num % 26;
            char digit = (char)(remainder + 97);
            result.insert(0, digit);
            num = (num - remainder) / 26;
        }
        return result.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String listProperties(@Nonnull Properties props, String what) {
        StringBuilder builder = new StringBuilder();
        builder.append("Listing ").append(what).append('\n');
        ArrayList<CallSite> propertyEntriesToOutput = new ArrayList<CallSite>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals("password") || key.equals("licensekey")) continue;
            String val = props.getProperty(key);
            String line = key + SPACE33.substring(Math.min(key.length(), SPACE33_LENGTH)) + "::= " + String.valueOf(val);
            propertyEntriesToOutput.add((CallSite)((Object)line));
        }
        String[] lines = new String[propertyEntriesToOutput.size()];
        propertyEntriesToOutput.toArray(lines);
        Arrays.sort(lines, String.CASE_INSENSITIVE_ORDER);
        for (String line : lines) {
            builder.append(line).append('\n');
        }
        builder.append("End of listing ").append(what);
        return builder.toString();
    }

    @Nonnull
    public static Collator getCollator() {
        return StringFunctions.getCollator(ClientLocale.getThreadLocale());
    }

    public static Collator getCollator(@Nonnull Locale locale) {
        Collator collator;
        HashMap<Locale, Collator> map = COLLATORS.get();
        if (map == null) {
            map = new HashMap();
            COLLATORS.set(map);
        }
        if ((collator = map.get(locale)) == null) {
            collator = Collator.getInstance(locale);
            map.put(locale, collator);
        }
        return collator;
    }

    public static String stringValueOf(Object value) {
        return value == null ? null : value.toString();
    }

    static {
        HTML_CHARS.put("quot", 34);
        HTML_CHARS.put("amp", 38);
        HTML_CHARS.put("lt", 60);
        HTML_CHARS.put("gt", 62);
        HTML_CHARS.put("nbsp", 160);
        HTML_CHARS.put("iexcl", 161);
        HTML_CHARS.put("cent", 162);
        HTML_CHARS.put("pound", 163);
        HTML_CHARS.put("curren", 164);
        HTML_CHARS.put("yen", 165);
        HTML_CHARS.put("brvbar", 166);
        HTML_CHARS.put("sect", 167);
        HTML_CHARS.put("uml", 168);
        HTML_CHARS.put("copy", 169);
        HTML_CHARS.put("ordf", 170);
        HTML_CHARS.put("laquo", 171);
        HTML_CHARS.put("not", 172);
        HTML_CHARS.put("shy", 173);
        HTML_CHARS.put("reg", 174);
        HTML_CHARS.put("macr", 175);
        HTML_CHARS.put("deg", 176);
        HTML_CHARS.put("plusmn", 177);
        HTML_CHARS.put("sup2", 178);
        HTML_CHARS.put("sup3", 179);
        HTML_CHARS.put("acute", 180);
        HTML_CHARS.put("micro", 181);
        HTML_CHARS.put("para", 182);
        HTML_CHARS.put("middot", 183);
        HTML_CHARS.put("cedil", 184);
        HTML_CHARS.put("sup1", 185);
        HTML_CHARS.put("ordm", 186);
        HTML_CHARS.put("raquo", 187);
        HTML_CHARS.put("frac14", 188);
        HTML_CHARS.put("frac12", 189);
        HTML_CHARS.put("frac34", 190);
        HTML_CHARS.put("iquest", 191);
        HTML_CHARS.put("Agrave", 192);
        HTML_CHARS.put("Aacute", 193);
        HTML_CHARS.put("Acirc", 194);
        HTML_CHARS.put("Atilde", 195);
        HTML_CHARS.put("Auml", 196);
        HTML_CHARS.put("Aring", 197);
        HTML_CHARS.put("AElig", 198);
        HTML_CHARS.put("Ccedil", 199);
        HTML_CHARS.put("Egrave", 200);
        HTML_CHARS.put("Eacute", 201);
        HTML_CHARS.put("Ecirc", 202);
        HTML_CHARS.put("Euml", 203);
        HTML_CHARS.put("Igrave", 204);
        HTML_CHARS.put("Iacute", 205);
        HTML_CHARS.put("Icirc", 206);
        HTML_CHARS.put("Iuml", 207);
        HTML_CHARS.put("ETH", 208);
        HTML_CHARS.put("Ntilde", 209);
        HTML_CHARS.put("Ograve", 210);
        HTML_CHARS.put("Oacute", 211);
        HTML_CHARS.put("Ocirc", 212);
        HTML_CHARS.put("Otilde", 213);
        HTML_CHARS.put("Ouml", 214);
        HTML_CHARS.put("times", 215);
        HTML_CHARS.put("Oslash", 216);
        HTML_CHARS.put("Ugrave", 217);
        HTML_CHARS.put("Uacute", 218);
        HTML_CHARS.put("Ucirc", 219);
        HTML_CHARS.put("Uuml", 220);
        HTML_CHARS.put("Yacute", 221);
        HTML_CHARS.put("THORN", 222);
        HTML_CHARS.put("szlig", 223);
        HTML_CHARS.put("agrave", 224);
        HTML_CHARS.put("aacute", 225);
        HTML_CHARS.put("acirc", 226);
        HTML_CHARS.put("atilde", 227);
        HTML_CHARS.put("auml", 228);
        HTML_CHARS.put("aring", 229);
        HTML_CHARS.put("aelig", 230);
        HTML_CHARS.put("ccedil", 231);
        HTML_CHARS.put("egrave", 232);
        HTML_CHARS.put("eacute", 233);
        HTML_CHARS.put("ecirc", 234);
        HTML_CHARS.put("euml", 235);
        HTML_CHARS.put("igrave", 236);
        HTML_CHARS.put("iacute", 237);
        HTML_CHARS.put("icirc", 238);
        HTML_CHARS.put("iuml", 239);
        HTML_CHARS.put("eth", 240);
        HTML_CHARS.put("ntilde", 241);
        HTML_CHARS.put("ograve", 242);
        HTML_CHARS.put("oacute", 243);
        HTML_CHARS.put("ocirc", 244);
        HTML_CHARS.put("otilde", 245);
        HTML_CHARS.put("ouml", 246);
        HTML_CHARS.put("divide", 247);
        HTML_CHARS.put("oslash", 248);
        HTML_CHARS.put("ugrave", 249);
        HTML_CHARS.put("uacute", 250);
        HTML_CHARS.put("ucirc", 251);
        HTML_CHARS.put("uuml", 252);
        HTML_CHARS.put("yacute", 253);
        HTML_CHARS.put("thorn", 254);
        HTML_CHARS.put("yuml", 255);
        HTML_CHARS.put("Alpha", 913);
        HTML_CHARS.put("alpha", 945);
        HTML_CHARS.put("Beta", 914);
        HTML_CHARS.put("beta", 946);
        HTML_CHARS.put("Gamma", 915);
        HTML_CHARS.put("gamma", 947);
        HTML_CHARS.put("Delta", 916);
        HTML_CHARS.put("delta", 948);
        HTML_CHARS.put("Epsilon", 917);
        HTML_CHARS.put("epsilon", 949);
        HTML_CHARS.put("Zeta", 918);
        HTML_CHARS.put("zeta", 950);
        HTML_CHARS.put("Eta", 919);
        HTML_CHARS.put("eta", 951);
        HTML_CHARS.put("Theta", 920);
        HTML_CHARS.put("theta", 952);
        HTML_CHARS.put("Iota", 921);
        HTML_CHARS.put("iota", 953);
        HTML_CHARS.put("Kappa", 922);
        HTML_CHARS.put("kappa", 954);
        HTML_CHARS.put("Lambda", 923);
        HTML_CHARS.put("lambda", 955);
        HTML_CHARS.put("Mu", 924);
        HTML_CHARS.put("mu", 956);
        HTML_CHARS.put("Nu", 925);
        HTML_CHARS.put("nu", 957);
        HTML_CHARS.put("Xi", 926);
        HTML_CHARS.put("xi", 958);
        HTML_CHARS.put("Omicron", 927);
        HTML_CHARS.put("omicron", 959);
        HTML_CHARS.put("Pi", 928);
        HTML_CHARS.put("pi", 960);
        HTML_CHARS.put("Rho", 929);
        HTML_CHARS.put("rho", 961);
        HTML_CHARS.put("Sigma", 931);
        HTML_CHARS.put("sigmaf", 962);
        HTML_CHARS.put("sigma", 963);
        HTML_CHARS.put("Tau", 932);
        HTML_CHARS.put("tau", 964);
        HTML_CHARS.put("Upsilon", 933);
        HTML_CHARS.put("upsilon", 965);
        HTML_CHARS.put("Phi", 934);
        HTML_CHARS.put("phi", 966);
        HTML_CHARS.put("Chi", 935);
        HTML_CHARS.put("chi", 967);
        HTML_CHARS.put("Psi", 936);
        HTML_CHARS.put("psi", 968);
        HTML_CHARS.put("Omega", 937);
        HTML_CHARS.put("omega", 969);
        HTML_CHARS.put("thetasym", 977);
        HTML_CHARS.put("upsih", 978);
        HTML_CHARS.put("piv", 982);
        HTML_CHARS.put("forall", 8704);
        HTML_CHARS.put("part", 8706);
        HTML_CHARS.put("exist", 8707);
        HTML_CHARS.put("empty", 8709);
        HTML_CHARS.put("nabla", 8711);
        HTML_CHARS.put("isin", 8712);
        HTML_CHARS.put("notin", 8713);
        HTML_CHARS.put("ni", 8715);
        HTML_CHARS.put("prod", 8719);
        HTML_CHARS.put("sum", 8721);
        HTML_CHARS.put("minus", 8722);
        HTML_CHARS.put("lowast", 8727);
        HTML_CHARS.put("radic", 8730);
        HTML_CHARS.put("prop", 8733);
        HTML_CHARS.put("infin", 8734);
        HTML_CHARS.put("ang", 8736);
        HTML_CHARS.put("and", 8869);
        HTML_CHARS.put("or", 8870);
        HTML_CHARS.put("cap", 8745);
        HTML_CHARS.put("cup", 8746);
        HTML_CHARS.put("int", 8747);
        HTML_CHARS.put("there4", 8756);
        HTML_CHARS.put("sim", 8764);
        HTML_CHARS.put("cong", 8773);
        HTML_CHARS.put("asymp", 8776);
        HTML_CHARS.put("ne", 8800);
        HTML_CHARS.put("equiv", 8801);
        HTML_CHARS.put("le", 8804);
        HTML_CHARS.put("ge", 8805);
        HTML_CHARS.put("sub", 8834);
        HTML_CHARS.put("sup", 8835);
        HTML_CHARS.put("nsub", 8836);
        HTML_CHARS.put("sube", 8838);
        HTML_CHARS.put("supe", 8839);
        HTML_CHARS.put("oplus", 8853);
        HTML_CHARS.put("otimes", 8855);
        HTML_CHARS.put("perp", 8869);
        HTML_CHARS.put("sdot", 8901);
        HTML_CHARS.put("loz", 9674);
        HTML_CHARS.put("lceil", 8968);
        HTML_CHARS.put("rceil", 8969);
        HTML_CHARS.put("lfloor", 8970);
        HTML_CHARS.put("rfloor", 8971);
        HTML_CHARS.put("lang", 9001);
        HTML_CHARS.put("rang", 9002);
        HTML_CHARS.put("larr", 8592);
        HTML_CHARS.put("uarr", 8593);
        HTML_CHARS.put("rarr", 8594);
        HTML_CHARS.put("darr", 8595);
        HTML_CHARS.put("harr", 8596);
        HTML_CHARS.put("crarr", 8629);
        HTML_CHARS.put("lArr", 8656);
        HTML_CHARS.put("uArr", 8657);
        HTML_CHARS.put("rArr", 8658);
        HTML_CHARS.put("dArr", 8659);
        HTML_CHARS.put("hArr", 8660);
        HTML_CHARS.put("bull", 8226);
        HTML_CHARS.put("hellip", 8230);
        HTML_CHARS.put("prime", 8242);
        HTML_CHARS.put("oline", 8254);
        HTML_CHARS.put("frasl", 8260);
        HTML_CHARS.put("weierp", 8472);
        HTML_CHARS.put("image", 8465);
        HTML_CHARS.put("real", 8476);
        HTML_CHARS.put("trade", 8482);
        HTML_CHARS.put("euro", 8364);
        HTML_CHARS.put("alefsym", 8501);
        HTML_CHARS.put("spades", 9824);
        HTML_CHARS.put("clubs", 9827);
        HTML_CHARS.put("hearts", 9829);
        HTML_CHARS.put("diams", 9830);
        HTML_CHARS.put("ensp", 8194);
        HTML_CHARS.put("emsp", 8195);
        HTML_CHARS.put("thinsp", 8201);
        HTML_CHARS.put("zwnj", 8204);
        HTML_CHARS.put("zwj", 8205);
        HTML_CHARS.put("lrm", 8206);
        HTML_CHARS.put("rlm", 8207);
        HTML_CHARS.put("ndash", 8211);
        HTML_CHARS.put("mdash", 8212);
        HTML_CHARS.put("lsquo", 8216);
        HTML_CHARS.put("rsquo", 8217);
        HTML_CHARS.put("sbquo", 8218);
        HTML_CHARS.put("ldquo", 8220);
        HTML_CHARS.put("rdquo", 8221);
        HTML_CHARS.put("bdquo", 8222);
        HTML_CHARS.put("dagger", 8224);
        HTML_CHARS.put("Dagger", 8225);
        HTML_CHARS.put("permil", 8240);
        HTML_CHARS.put("lsaquo", 8249);
        HTML_CHARS.put("rsaquo", 8250);
    }

    private static enum NumSet {
        I(1),
        IV(4),
        V(5),
        IX(9),
        X(10),
        XL(40),
        L(50),
        XC(90),
        C(100),
        CD(400),
        D(500),
        CM(900),
        M(1000);

        private final int value;

        private NumSet(int value) {
            this.value = value;
        }
    }
}

