/*
 * Decompiled with CFR 0.152.
 */
package com.inet.error;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCodeHelper;
import java.text.MessageFormat;
import java.util.ResourceBundle;

@InternalApi
public interface ErrorCode {
    public String name();

    public int getErrorCodeNumber();

    default public String getMsg(Object ... params) {
        Object baseName = this.getClass().getName();
        baseName = ((String)baseName).substring(0, ((String)baseName).lastIndexOf(46)) + ".LanguageResources";
        ResourceBundle bundle = ErrorCodeHelper.getBundle((String)baseName, this.getClass());
        String msg = this.name();
        try {
            msg = bundle.getString(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            msg = MessageFormat.format(msg, params);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }

    public static ErrorCode valueOf(int code) {
        return ErrorCodeHelper.ERROR_CODES.get(code);
    }

    public static <E extends Throwable> E throwAny(Throwable e) throws E {
        throw e;
    }
}

