/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.remote.client;

import com.inet.pdfc.remote.client.RPCClient;
import com.inet.pdfc.remote.client.ServiceDiscovery;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;

public class PdfcServerInfo {
    private static final String DEFAULT_URL = "http://localhost:9900/websocket";
    private static Map<String, String> allServiceLocations;
    private String servicePath;
    private List<String> cookies;
    private String user;
    private String password;

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="URLs are constructed from multicast scans an cannot be modified externally.")
    void init() throws IOException {
        if (this.cookies == null) {
            URL url = new URL(this.getServicePath());
            RPCClient.getLogger().info("Login to " + url);
            URLConnection conn = url.openConnection();
            if (this.user != null) {
                PdfcServerInfo.setAuthorization(conn, this.user, this.password);
            }
            if (((HttpURLConnection)conn).getResponseCode() == 401 && this.user == null) {
                this.cookies = PdfcServerInfo.readCookies(conn, this.cookies);
                conn = url.openConnection();
                PdfcServerInfo.setAuthorization(conn, System.getProperty("user.name"), "");
                PdfcServerInfo.setCookies(conn, this.cookies);
            }
            try {
                conn.getInputStream();
                this.cookies = PdfcServerInfo.readCookies(conn, this.cookies);
            }
            catch (IOException ex) {
                this.cookies = null;
                throw ex;
            }
        }
    }

    private static List<String> readCookies(URLConnection conn, List<String> oldCookies) {
        List<String> cookies = conn.getHeaderFields().get("Set-Cookie");
        if (cookies != null) {
            cookies = new ArrayList<String>(cookies);
            for (int i = 0; i < cookies.size(); ++i) {
                String cookie = cookies.get(i);
                int idx = cookie.indexOf(59);
                if (idx <= 0) continue;
                cookies.set(i, cookie.substring(0, idx));
            }
            if (oldCookies != null) {
                oldCookies.addAll(cookies);
                return oldCookies;
            }
            return cookies;
        }
        return oldCookies;
    }

    private static void setCookies(URLConnection conn, List<String> cookies) {
        if (cookies != null) {
            for (String cookie : cookies) {
                conn.addRequestProperty("Cookie", cookie);
            }
        }
    }

    private static void setAuthorization(URLConnection conn, String user, String password) {
        conn.setRequestProperty("Authorization", "Basic " + Base64.getMimeEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.UTF_8)));
    }

    public void setServicePath(String servicePath) {
        block5: {
            if (servicePath != null) {
                if (servicePath.indexOf("://") < 0) {
                    servicePath = "http://" + servicePath;
                }
                try {
                    URL url = new URL(servicePath);
                    String path = url.getPath();
                    if (!path.isEmpty() && !path.equals("/")) break block5;
                    servicePath = new URL(url, "/websocket").toString();
                    Map<String, String> allServiceLocations = PdfcServerInfo.getAllServiceLocations();
                    for (String str : allServiceLocations.values()) {
                        URL urlLoc = new URL(str);
                        if (!url.getHost().equalsIgnoreCase(urlLoc.getHost())) continue;
                        servicePath = str;
                        break;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        this.servicePath = servicePath;
        this.cookies = null;
    }

    public void setCredentials(String user, String password) {
        this.user = user;
        this.password = password == null ? "" : password;
        this.cookies = null;
    }

    public String getServicePath() {
        if (this.servicePath == null) {
            this.servicePath = DEFAULT_URL;
            String path = PdfcServerInfo.getAllServiceLocations().values().stream().findFirst().orElse(null);
            if (path != null) {
                this.servicePath = path;
            }
        }
        return this.servicePath;
    }

    public List<String> getCookies() {
        return this.cookies;
    }

    private static Map<String, String> getAllServiceLocations() {
        if (allServiceLocations == null) {
            try {
                allServiceLocations = new ServiceDiscovery().getAllServiceLocations();
            }
            catch (IOException e) {
                RPCClient.getLogger().error(e);
                allServiceLocations = Collections.emptyMap();
            }
        }
        return allServiceLocations;
    }
}

