/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.text;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.FontInfo;
import com.inet.pdfc.model.PaintComparator;
import com.inet.pdfc.model.TextElement;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Paint;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

@InternalApi
public class TextStyle
implements Serializable {
    private double slope;
    private double rotation;
    private float fontSize;
    private FontInfo font;
    private transient Paint strokePaint;
    private transient Paint fillPaint;
    private transient Paint backgroundPaint = new Color(0, 0, 0, 0);
    private int style;
    private double textHeight;
    private double wsWidth;
    private double wsWidthScaled;
    private double averageKerning = Double.NaN;
    private double actualSpaceWidth = Double.NaN;

    public TextStyle(double rotation, float fontSize, FontInfo font) {
        this.rotation = rotation;
        this.fontSize = fontSize;
        this.font = font;
        this.strokePaint = null;
        this.fillPaint = Color.BLACK;
        this.style = font != null ? font.getStyle() : 0;
        this.textHeight = fontSize * 4.0f / 3.0f;
        this.wsWidthScaled = this.wsWidth = font != null ? (double)((int)Math.round(font.getWSWidth(fontSize)) / 20) : (double)(fontSize / 3.0f);
    }

    public TextStyle(TextElement pdfText, double wsWidthFactor) {
        TextStyle style = pdfText.getStyle();
        this.textHeight = pdfText.getStyle().getTextHeight() * Math.abs(pdfText.getTransformMatrix()[1] + pdfText.getTransformMatrix()[3]);
        this.font = style.getFont();
        this.fontSize = style.getFontSize();
        this.strokePaint = style.getStrokePaint();
        this.fillPaint = style.getFillPaint();
        this.style = style.getStyle();
        this.slope = style.getSlope();
        this.rotation = style.getRotation();
        this.wsWidth = style.getWsWidth() * wsWidthFactor;
        this.wsWidthScaled = style.getWsWidthScaled() * wsWidthFactor;
        this.actualSpaceWidth = style.getActualSpaceWidth();
        this.averageKerning = style.getAverageKerning();
    }

    public TextStyle(@Nonnull TextStyle source) {
        this.slope = source.slope;
        this.rotation = source.rotation;
        this.fontSize = source.fontSize;
        this.font = source.font;
        this.strokePaint = source.strokePaint;
        this.fillPaint = source.fillPaint;
        this.backgroundPaint = source.backgroundPaint;
        this.style = source.style;
        this.textHeight = source.textHeight;
        this.wsWidth = source.wsWidth;
        this.wsWidthScaled = source.wsWidthScaled;
        this.averageKerning = source.averageKerning;
        this.actualSpaceWidth = source.actualSpaceWidth;
        this.actualSpaceWidth = source.getActualSpaceWidth();
        this.averageKerning = source.getAverageKerning();
    }

    public TextStyle(FontInfo fontInfo, float fontSize, Paint fillPaint, Paint strokePaint) {
        this.font = fontInfo;
        this.fontSize = fontSize;
        this.strokePaint = strokePaint;
        this.fillPaint = fillPaint;
        this.wsWidthScaled = this.wsWidth = (double)((int)Math.round(fontInfo.getWSWidth(fontSize))) / 20.0;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
    }

    public boolean hasUnderline() {
        return (this.style & 4) > 0;
    }

    public boolean hasStrikethrough() {
        return (this.style & 8) > 0;
    }

    public boolean isSuperscript() {
        return (this.style & 0x20) > 0;
    }

    public boolean isSubscript() {
        return (this.style & 0x10) > 0;
    }

    public void setBold() {
        this.style |= 1;
    }

    public void setItalic() {
        this.style |= 2;
    }

    public void setUnderlined() {
        this.style |= 4;
    }

    public void setStrikethrough() {
        this.style |= 8;
    }

    public void setSuperscript() {
        this.style |= 0x20;
    }

    public void setSubscript() {
        this.style |= 0x10;
    }

    public double getWsWidth() {
        return this.wsWidth;
    }

    public void setWsWidth(double wsWidth) {
        this.wsWidth = wsWidth;
    }

    public double getWsWidthScaled() {
        return this.wsWidthScaled;
    }

    public void setWsWidthScaled(double wsWidthScaled) {
        this.wsWidthScaled = wsWidthScaled;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public FontInfo getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public int getStyle() {
        return this.style;
    }

    public double getTextHeight() {
        return this.textHeight;
    }

    public void setTextHeight(double textHeight) {
        this.textHeight = textHeight;
    }

    public double getMinimumWhiteSpaceSize() {
        return this.wsWidth;
    }

    public double getMinimumScaledWhiteSpaceSize() {
        return this.wsWidthScaled;
    }

    public double getActualSpaceWidth() {
        return this.actualSpaceWidth;
    }

    public double getAverageKerning() {
        return this.averageKerning;
    }

    public void setActualSpaceWidth(double actualSpaceWidth) {
        this.actualSpaceWidth = actualSpaceWidth;
    }

    public void setAverageKerning(double averageKerning) {
        this.averageKerning = averageKerning;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextStyle)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TextStyle other = (TextStyle)obj;
        if (Double.compare(this.fontSize, other.fontSize) != 0) {
            return false;
        }
        if (Double.compare(this.textHeight, other.textHeight) != 0) {
            return false;
        }
        if (Double.compare(this.slope, other.slope) != 0) {
            return false;
        }
        if (this.style != other.style) {
            return false;
        }
        if (!this.font.getActualFontName().equals(other.font.getActualFontName()) || !this.font.getFamilyName().equals(other.font.getFamilyName())) {
            return false;
        }
        if (this.font.getStyle() != other.font.getStyle()) {
            return false;
        }
        return this.font.hasWhiteSpace() == other.font.hasWhiteSpace();
    }

    public boolean equalsWithColors(TextStyle other) {
        if (!this.equals(other)) {
            return false;
        }
        PaintComparator comparator = new PaintComparator(0.01);
        if (!comparator.isEqual(this.fillPaint, other.fillPaint)) {
            return false;
        }
        return comparator.isEqual(this.strokePaint, other.strokePaint);
    }

    public String toString() {
        return "TextStyle{slope=" + this.slope + ", rotation=" + this.rotation + ", fontSize=" + this.fontSize + ", font=" + this.font + ", strokePaint=" + this.strokePaint + ", fillPaint=" + this.fillPaint + ", style=" + this.style + ", textHeight=" + this.textHeight + ", wsWidth=" + this.wsWidth + ", wsWidthScaled=" + this.wsWidthScaled + ", hasUnderline=" + this.hasUnderline() + ", hasStrikethrough=" + this.hasStrikethrough() + ", isSuperscript=" + this.isSuperscript() + ", isSubscript=" + this.isSubscript() + '}';
    }

    public boolean isSimilar(TextStyle other) {
        if ((double)Math.abs(this.fontSize - other.fontSize) > 0.05) {
            return false;
        }
        return this.font.getActualFontName().equals(other.font.getActualFontName()) && this.font.getFamilyName().equals(other.font.getFamilyName());
    }

    public int hashCode() {
        int hash = this.font.getActualFontName().hashCode() * Double.hashCode(this.fontSize) * Double.hashCode(this.textHeight) + this.style;
        if (this.slope != 0.0) {
            hash *= Double.hashCode(this.slope);
        }
        return hash;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!(this.font instanceof Serializable)) {
            this.font = new SerializableFontInfo(this.font);
        }
        out.defaultWriteObject();
        if (this.strokePaint == null || this.strokePaint instanceof Serializable) {
            out.writeObject(this.strokePaint);
        } else {
            out.writeObject(null);
        }
        if (this.fillPaint == null || this.fillPaint instanceof Serializable) {
            out.writeObject(this.fillPaint);
        } else {
            out.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.strokePaint = (Paint)in.readObject();
        this.fillPaint = (Paint)in.readObject();
    }

    private static class SerializableFontInfo
    implements FontInfo,
    Serializable {
        private float ascend;
        private String familyName;
        private String fontName;
        private FontMetrics metrics;
        private int style;
        private double wsWidth;

        public SerializableFontInfo(FontInfo source) {
            this.ascend = source.getAscend(100);
            this.familyName = source.getFamilyName();
            this.fontName = source.getFontName();
            this.metrics = source.getMetrics(100);
            this.style = source.getStyle();
            this.wsWidth = source.getWSWidth(100.0f);
        }

        @Override
        public double getWSWidth(float fontSize) {
            return this.wsWidth * (double)fontSize / 100.0;
        }

        @Override
        public FontMetrics getMetrics(int size) {
            return Toolkit.getDefaultToolkit().getFontMetrics(this.metrics.getFont().deriveFont(size));
        }

        @Override
        public float getAscend(int size) {
            return this.ascend * (float)size / 100.0f;
        }

        @Override
        public String getFamilyName() {
            return this.familyName;
        }

        @Override
        public int getStyle() {
            return this.style;
        }

        @Override
        public String getFontName() {
            return this.fontName;
        }
    }
}

