/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.persistence.RandomAccessRead;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonData
@PublicApi
public abstract class PdfSource
implements Comparable<PdfSource>,
Serializable {
    protected static final String KEY_PASSWORD = "PASSWORD";
    protected static final String KEY_NAME = "NAME";
    protected static final String KEY_PATH = "PATH";
    protected static final String KEY_LAST_MODIFIED = "lastModified";
    protected static final String KEY_SIZE = "size";
    private static final String KEY_PAGE_LIMIT = "LIMIT";
    private static final String KEY_DOCUMENT_LANGUAGE = "LANGUAGE";
    private Map<String, String> metaProperties = new HashMap<String, String>();

    public PdfSource() {
        this("", null, 0L, 0L);
    }

    protected PdfSource(String name, String path, long lastModified, long size) {
        this.getMetaProperties().put(KEY_NAME, name);
        this.getMetaProperties().put(KEY_PATH, path);
        this.getMetaProperties().put(KEY_LAST_MODIFIED, Long.toString(lastModified));
        this.getMetaProperties().put(KEY_SIZE, Long.toString(size));
    }

    public void setLanguage(String language) {
        this.getMetaProperties().put(KEY_DOCUMENT_LANGUAGE, language);
    }

    public String getLanguage() {
        return this.getMetaProperties().get(KEY_DOCUMENT_LANGUAGE);
    }

    public void setPageLimit(int pageLimited) {
        if (pageLimited > 0) {
            this.getMetaProperties().put(KEY_PAGE_LIMIT, pageLimited + "");
        } else {
            this.getMetaProperties().remove(KEY_PAGE_LIMIT);
        }
    }

    public String getName() {
        return this.getMetaProperties().get(KEY_NAME);
    }

    public String getPath() {
        return this.getMetaProperties().get(KEY_PATH);
    }

    public long getLastModified() {
        String value = this.getMetaProperties().get(KEY_LAST_MODIFIED);
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getSize() {
        String value = this.getMetaProperties().get(KEY_SIZE);
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public abstract RandomAccessRead getContent() throws IOException;

    public String getPassword() {
        return this.metaProperties.get(KEY_PASSWORD);
    }

    public void setPassword(String password) {
        this.metaProperties.put(KEY_PASSWORD, password);
    }

    protected Map<String, String> getMetaProperties() {
        return this.metaProperties;
    }

    @Override
    public int compareTo(PdfSource o) {
        if (o == null) {
            return 1;
        }
        int result = this.getName().toLowerCase().compareTo(o.getName().toLowerCase());
        return result != 0 ? result : this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PdfSource)) {
            return false;
        }
        PdfSource other = (PdfSource)obj;
        if (other.getSize() != this.getSize()) {
            return false;
        }
        return this.getName() != null ? this.getName().equals(other.getName()) : other.getName() == null;
    }

    public int hashCode() {
        return (int)this.getSize() + (this.getName() != null ? this.getName().hashCode() : 0);
    }
}

