/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence;

import com.inet.annotations.InternalApi;
import com.inet.persistence.file.FileRandomAccessRead;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

@InternalApi
public abstract class RandomAccessRead
implements Closeable {
    public abstract long length() throws IOException;

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int readCompletely(byte[] b) throws IOException {
        return this.readCompletely(b, 0, b.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public int readCompletely(byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        for (n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            return n == 0 ? -1 : n;
        }
        return n;
    }

    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public abstract int read() throws IOException;

    public abstract void seek(long var1) throws IOException;

    public static RandomAccessRead wrap(byte[] content) {
        return new ByteArrayRandomAccessRead(content);
    }

    public static RandomAccessRead wrap(File file) {
        try {
            return new FileRandomAccessRead(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class ByteArrayRandomAccessRead
    extends RandomAccessRead {
        private byte[] source;
        private int position;

        public ByteArrayRandomAccessRead(byte[] source) {
            this.source = source;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public long length() throws IOException {
            return this.source.length;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.position >= this.source.length) {
                return -1;
            }
            len = Math.min(len, this.source.length - this.position);
            System.arraycopy(this.source, this.position, b, off, len);
            this.position += len;
            return len;
        }

        @Override
        public int read() throws IOException {
            if (this.position >= this.source.length) {
                return -1;
            }
            return this.source[this.position++];
        }

        @Override
        public void seek(long pos) throws IOException {
            this.position = (int)pos;
        }
    }
}

