/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.DifferencePages;
import com.inet.pdfc.generator.model.ModificationFormatter;
import com.inet.pdfc.generator.model.diff.AttributeDifference;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonData
@PublicApi
public class Modification
implements Serializable {
    private static final long serialVersionUID = 8764787070296351309L;
    private ModificationType type;
    private List<PagedElement> affectedFirst;
    private List<PagedElement> affectedSecond;
    private List<AttributeDifference<?>> changes;
    private DiffGroup.GroupType sourceType;
    private boolean shouldPageElementMerge = false;
    private transient boolean visible = true;

    private Modification() {
    }

    public Modification(DiffGroup.GroupType sourceType, List<PagedElement> affectedFirst, List<PagedElement> affectedSecond, List<AttributeDifference<?>> changes) {
        if (affectedFirst == null) {
            affectedFirst = new ArrayList<PagedElement>();
        }
        if (affectedSecond == null) {
            affectedSecond = new ArrayList<PagedElement>();
        }
        if (sourceType != null) {
            switch (sourceType) {
                case AddedOrRemoved: {
                    if (affectedFirst.size() > 0 && affectedSecond.size() > 0) {
                        throw new IllegalArgumentException("Cannot create a single modification for add AND remove. Create two distinct modifications instead!");
                    }
                    if (affectedFirst.size() == 0 && affectedSecond.size() == 0) {
                        throw new IllegalArgumentException("Cannot create an AddOrRemoved modification without any added or removed elements!");
                    }
                    if (changes != null && !changes.isEmpty()) {
                        throw new IllegalArgumentException("Attribute changes are not allow for type 'add' or 'remove' modifications!");
                    }
                    this.type = affectedFirst.size() > 0 ? ModificationType.remove : ModificationType.add;
                    break;
                }
                case Replaced: {
                    this.type = ModificationType.replace;
                    break;
                }
                case ValidationError: {
                    this.type = ModificationType.validationError;
                    break;
                }
                default: {
                    if (changes == null || changes.isEmpty()) {
                        throw new IllegalArgumentException("A 'attribute change' modification requires a list of attribute changes!");
                    }
                    this.type = ModificationType.attributeDifference;
                }
            }
        }
        this.sourceType = sourceType;
        this.affectedFirst = affectedFirst;
        this.affectedSecond = affectedSecond;
        this.changes = changes;
    }

    public Modification(DiffGroup.GroupType sourceType, PagedElement affectedFirst, PagedElement affectedSecond, List<AttributeDifference<?>> changes) {
        this(sourceType, affectedFirst != null ? new ArrayList<PagedElement>(Arrays.asList(affectedFirst)) : new ArrayList(), (List<PagedElement>)(affectedSecond != null ? new ArrayList<PagedElement>(Arrays.asList(affectedSecond)) : new ArrayList()), changes);
        if ((affectedFirst == null || affectedSecond == null) && changes != null) {
            throw new IllegalArgumentException("Cannot create a modification for null-elements!");
        }
    }

    public void setShouldMerge(boolean shouldMerge) {
        this.shouldPageElementMerge = shouldMerge;
    }

    public boolean isShouldPageElementMerge() {
        return this.shouldPageElementMerge;
    }

    public ModificationType getModificationType() {
        return this.type;
    }

    public DifferencePages getDifferencePages(boolean first) {
        List<PagedElement> affectedElements = this.getAffectedElements(first);
        if (affectedElements.size() > 0) {
            int startPage = -1;
            int endPage = -1;
            for (PagedElement affectedElement : affectedElements) {
                int pageNumber = affectedElement.getPageIndex() + 1;
                if (startPage == -1) {
                    endPage = startPage = pageNumber;
                }
                if (pageNumber < startPage) {
                    startPage = pageNumber;
                }
                if (pageNumber <= endPage) continue;
                endPage = pageNumber;
            }
            return new DifferencePages(startPage, endPage);
        }
        return null;
    }

    public DiffGroup.GroupType getSourceType() {
        return this.sourceType;
    }

    public List<PagedElement> getAffectedElements(boolean first) {
        return first ? this.affectedFirst : this.affectedSecond;
    }

    public ElementType getContentType() {
        ElementType elementType = this.affectedFirst.size() > 0 ? this.affectedFirst.get(0).getType() : (this.affectedSecond.size() > 0 ? this.affectedSecond.get(0).getType() : ElementType.Text);
        return elementType.getBaseType();
    }

    public List<AttributeDifference<?>> getAttributeDifferences() {
        return this.changes;
    }

    public <T extends AttributeDifference<?>> T getAttributeDifference(Class<T> type) {
        if (this.changes == null || this.changes.size() == 0) {
            return null;
        }
        for (AttributeDifference<?> diff : this.changes) {
            if (type != diff.getClass()) continue;
            return (T)diff;
        }
        return null;
    }

    public String getMessage() {
        return new ModificationFormatter().format(this);
    }

    public String toString() {
        return this.getMessage();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @PublicApi
    public static enum ModificationType {
        add,
        remove,
        replace,
        attributeDifference,
        validationError;

    }
}

