/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.utils;

import com.inet.annotations.InternalApi;
import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class MimeTypes {
    public static final String UNKNOWN = "application/octet-stream";
    public static final String BIN = "application/crystalclear";
    public static final String PDF = "application/pdf";
    public static final String PS = "application/ps";
    public static final String RTF = "application/msword";
    public static final String XLS = "application/vnd.ms-excel";
    public static final String XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String CSV = "text/x-comma-separated-values";
    public static final String XML = "text/xml; charset=utf-8";
    public static final String TXT = "text/plain; charset=utf-8";
    public static final String HTM = "text/html; charset=utf-8";
    public static final String JPEG = "image/jpeg";
    public static final String JPG = "image/jpeg";
    public static final String JP2 = "image/jp2";
    public static final String PNG = "image/png";
    public static final String GIF = "image/gif";
    public static final String BMP = "image/bmp";
    public static final String SVG = "image/svg+xml";
    public static final String ICO = "image/x-icon";
    public static final String WEBP = "image/webp";
    public static final String AVIF = "image/avif";
    public static final String CSS = "text/css";
    public static final String ODS = "application/vnd.oasis.opendocument.spreadsheet";
    public static final String JSON = "application/json";
    public static final String JAVASCRIPT = "application/javascript; charset=utf-8";
    public static final String WOFF = "application/font-woff";
    public static final String DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String JRA = "application/jra";
    public static final String JAR = "application/java-archive";
    public static final String ZIP = "application/zip";
    public static final String JSON_BINARY = "application/binary-json";
    public static final String JSON_ERROR = "application/error-json";
    public static final String JSON_HELPDESK = "application/helpdesk-json";
    public static final String JSON_HELPDESK_ERROR = "application/helpdesk-error-json";
    public static final String MSI = "application/x-msi";
    public static final String DMG = "application/x-apple-diskimage";
    public static final String RPM = "application/x-redhat-package";
    public static final String DEB = "application/vnd.debian.binary-package";
    private static final HashMap<String, String> MAP = new HashMap();

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No file access")
    public static String getMimeType(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return UNKNOWN;
        }
        String type = fileName.substring(fileName.lastIndexOf(46) + 1);
        if ((type = MAP.get(type.toLowerCase())) == null) {
            try {
                if (!fileName.contains(".")) {
                    fileName = "x." + fileName;
                }
                type = Files.probeContentType(new File(fileName).toPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (type == null) {
                return UNKNOWN;
            }
        }
        return type;
    }

    @Nonnull
    public static String getMimeTypeFromData(byte[] data) {
        int offset = 0;
        block15: while (true) {
            if (data == null || data.length < 5 + offset) {
                return UNKNOWN;
            }
            switch (data[offset]) {
                case 0: {
                    if (data[offset + 4] != 106) break block15;
                    return JP2;
                }
                case -119: {
                    return PNG;
                }
                case 71: {
                    return GIF;
                }
                case 60: {
                    switch (data[offset + 1]) {
                        case 33: {
                            if (data[offset + 2] == 45) {
                                offset += 3;
                                while (data.length > offset && data[offset] != 62) {
                                    ++offset;
                                }
                                ++offset;
                                continue block15;
                            }
                        }
                        case 72: 
                        case 104: {
                            return HTM;
                        }
                        case 115: {
                            return SVG;
                        }
                        case 63: {
                            return XML;
                        }
                    }
                    break block15;
                }
                case -1: {
                    return "image/jpeg";
                }
                case 82: {
                    return WEBP;
                }
                case 10: 
                case 13: 
                case 32: {
                    ++offset;
                    continue block15;
                }
            }
            break;
        }
        return UNKNOWN;
    }

    static {
        MAP.put("pdf", PDF);
        MAP.put("ps", PS);
        MAP.put("rtf", RTF);
        MAP.put("pdf", PDF);
        MAP.put("xls", XLS);
        MAP.put("xlsx", XLSX);
        MAP.put("csv", CSV);
        MAP.put("xml", XML);
        MAP.put("txt", TXT);
        MAP.put("html", HTM);
        MAP.put("htm", HTM);
        MAP.put("jpg", "image/jpeg");
        MAP.put("jpeg", "image/jpeg");
        MAP.put("jp2", JP2);
        MAP.put("png", PNG);
        MAP.put("gif", GIF);
        MAP.put("bmp", BMP);
        MAP.put("ico", ICO);
        MAP.put("webp", WEBP);
        MAP.put("avif", AVIF);
        MAP.put("css", CSS);
        MAP.put("svg", SVG);
        MAP.put("ods", ODS);
        MAP.put("json", JSON);
        MAP.put("js", JAVASCRIPT);
        MAP.put("woff", WOFF);
        MAP.put("jra", JRA);
        MAP.put("jar", JAR);
        MAP.put("zip", ZIP);
        MAP.put("docx", DOCX);
        MAP.put("msi", MSI);
        MAP.put("dmg", DMG);
        MAP.put("rpm", RPM);
        MAP.put("deb", DEB);
    }
}

