/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.io.UTF8StreamReader;
import com.inet.lib.json.BaseParser;
import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonTypeResolver;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

class BonParser
extends BaseParser {
    private final InputStream input;
    private final HashMap<Integer, Object> keys = new HashMap();

    BonParser(InputStream input, Map<Object, Map<String, Object>> extraFields, JsonTypeResolver typeResolver) throws IOException {
        super(extraFields, typeResolver, new Function<Object, Object>(){
            private HashMap<Object, Object> objectPool = new HashMap();

            @Override
            public Object apply(Object obj) {
                Object old = this.objectPool.get(obj);
                if (old != null) {
                    return old;
                }
                this.objectPool.put(obj, obj);
                return obj;
            }
        });
        this.input = input;
        if (input.read() != 66 || input.read() != 79 || input.read() != 78) {
            throw new JsonException("No valid BON data.");
        }
        input.read();
    }

    private int read() throws IOException {
        int result = this.input.read();
        if (result < 0) {
            throw new JsonException("Unexpected end of stream");
        }
        return result;
    }

    Object parseValue(Type type) throws IOException, JsonException {
        int token = this.read();
        return this.parseValue(token, type);
    }

    private Object parseValue(int token, Type type) throws IOException {
        switch (token) {
            case 33: {
                return null;
            }
            case 35: {
                return Boolean.TRUE;
            }
            case 34: {
                return Boolean.FALSE;
            }
            case 36: {
                return this.getObject(this.readLong(), type);
            }
            case 37: {
                return this.getObject(this.readLong() ^ 0xFFFFFFFFFFFFFFFFL, type);
            }
            case 38: {
                return this.readFloat(type);
            }
            case 39: {
                return this.readDouble(type);
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                return this.getObject(token & 0x1F, type);
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return this.getObject(~(token & 0x1F), type);
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                return this.readString(token & 0x3F, type);
            }
            case 44: {
                return this.readString((int)this.readLong(), type);
            }
            case 45: {
                return this.readBytes();
            }
            case 40: {
                return this.parseArray(type);
            }
            case 41: {
                return this.parseObject(type, true);
            }
            case 42: {
                return this.parseObject(type, false);
            }
        }
        throw new JsonException("Unknown type token: " + token);
    }

    private Object parseArray(Type type) throws IOException, JsonException {
        Class<?> elementClass;
        Collection<Object> list;
        ClassWrapper wrapper = ClassWrapper.getWrapper(type);
        Class<?> clazz = wrapper.getClazz();
        Type[] types = wrapper.getTypeArguments();
        Object elementType = types != null ? types[0] : Object.class;
        if (clazz.isArray()) {
            list = new ArrayList();
            elementType = elementClass = clazz.getComponentType();
        } else {
            list = (Collection)ClassWrapper.getWrapper(type).create();
            elementClass = null;
        }
        while (true) {
            int token = this.read();
            switch (token) {
                case 43: {
                    if (elementClass != null) {
                        int length = list.size();
                        Object result = Array.newInstance(elementClass, length);
                        int i = 0;
                        for (Object e : list) {
                            Array.set(result, i++, e);
                        }
                        return result;
                    }
                    return list;
                }
            }
            list.add(this.parseValue(token, (Type)elementType));
        }
    }

    Object parseObject(Type type, boolean useKeyReferences) throws IOException, JsonException {
        Object valueGenericType;
        Class<Object> keyGenericType;
        int objectType;
        Object obj;
        ClassWrapper wrapper = ClassWrapper.getWrapper(type);
        if (wrapper.hasGetTypeFor()) {
            obj = new BaseParser.JsonObject(this, wrapper);
            objectType = 2;
            keyGenericType = String.class;
            valueGenericType = null;
        } else {
            obj = wrapper.create();
            if (obj instanceof Map) {
                objectType = 1;
                Type[] types = wrapper.getTypeArguments();
                if (types != null) {
                    keyGenericType = types[0];
                    valueGenericType = types[1];
                } else {
                    valueGenericType = Object.class;
                    keyGenericType = Object.class;
                }
            } else {
                objectType = 0;
                keyGenericType = String.class;
                valueGenericType = null;
            }
        }
        block9: while (true) {
            int token = this.read();
            switch (token) {
                case 43: {
                    if (objectType == 2) {
                        return ((BaseParser.JsonObject)obj).create();
                    }
                    return obj;
                }
            }
            Object key = useKeyReferences ? this.parseKeyName(token) : this.parseValue(token, (Type)((Object)keyGenericType));
            switch (objectType) {
                default: {
                    Field field = wrapper.findField(String.valueOf(key));
                    if (field == null) {
                        this.saveExtraField(obj, String.valueOf(key));
                        break;
                    }
                    Type fieldType = this.typeResolver.getGenericType(obj, field);
                    Object value = this.parseValue(fieldType);
                    try {
                        field.set(obj, value);
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace(System.err);
                    }
                    continue block9;
                }
                case 1: {
                    valueGenericType = this.typeResolver.getMapValueType(key, (Type)valueGenericType);
                    Object value = this.parseValue((Type)valueGenericType);
                    ((Map)obj).put(key, value);
                    break;
                }
                case 2: {
                    Field field = wrapper.findField(String.valueOf(key));
                    if (field == null) {
                        ((BaseParser.JsonObject)obj).extraFieldValues.put(String.valueOf(key), this.parseValue((Type)((Object)Object.class)));
                        break;
                    }
                    Type fieldType = field.getGenericType();
                    Object value = this.parseValue(fieldType);
                    ((BaseParser.JsonObject)obj).fieldValues.put(String.valueOf(key), value);
                }
            }
        }
    }

    @Override
    Object parseExtraFieldValue() throws JsonException, IOException {
        return this.parseValue((Type)((Object)Object.class));
    }

    private Object parseKeyName(int token) throws IOException {
        switch (token) {
            case 36: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                return this.keys.get(this.parseValue(token, (Type)((Object)Integer.class)));
            }
        }
        Object key = this.parseValue(token, (Type)((Object)String.class));
        this.keys.put(this.keys.size(), key);
        return key;
    }

    private Object readString(int length, Type type) throws IOException {
        UTF8StreamReader reader = new UTF8StreamReader(this.input, false);
        char[] value = new char[length];
        reader.read(value);
        String str = new String(value);
        Object obj = ClassWrapper.getWrapper(type).valueOf(str, true);
        return obj == str ? this.pool(obj) : obj;
    }

    private Object readBytes() throws IOException, JsonException {
        int len = (int)this.readLong();
        byte[] value = new byte[len];
        int off = 0;
        while (len - off > 0) {
            int count = this.input.read(value, off, len);
            if (count < 0) {
                throw new JsonException("Unexpected end of stream");
            }
            off += count;
        }
        return value;
    }

    private Object getObject(long value, Type type) {
        int jsonType = ClassWrapper.getWrapper(type).getJsonType();
        switch (jsonType) {
            case 8: {
                return this.pool(new Date(value));
            }
            case 9: {
                return this.pool(value != 0L);
            }
            case 10: {
                return this.pool((byte)value);
            }
            case 11: {
                return this.pool((short)value);
            }
            case 12: {
                return this.pool((int)value);
            }
            case 13: {
                return this.pool(value);
            }
            case 14: {
                return this.pool(Float.valueOf(value));
            }
            case 15: {
                return this.pool(Double.valueOf(value));
            }
            case 16: {
                return this.pool(Character.valueOf((char)value));
            }
            case 7: {
                if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
                    return this.pool((int)value);
                }
                throw new JsonException("Value '" + value + "' can't convert to type: " + type);
            }
        }
        throw new JsonException("Unknown number type: " + jsonType);
    }

    private long readLong() throws IOException {
        int next;
        long value = 0L;
        do {
            next = this.read();
            value = (value << 7) + (long)(next & 0x7F);
        } while ((next & 0x80) == 0);
        return value;
    }

    private Object readFloat(Type type) throws IOException {
        int bits = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
        float value = Float.intBitsToFloat(bits);
        int jsonType = ClassWrapper.getWrapper(type).getJsonType();
        switch (jsonType) {
            case 9: {
                return this.pool(value != 0.0f);
            }
            case 10: {
                return this.pool((byte)value);
            }
            case 11: {
                return this.pool((short)value);
            }
            case 12: {
                return this.pool((int)value);
            }
            case 13: {
                return this.pool((long)value);
            }
            case 14: {
                return this.pool(Float.valueOf(value));
            }
            case 15: {
                return this.pool(Double.valueOf(value));
            }
            case 16: {
                return this.pool(Character.valueOf((char)value));
            }
        }
        throw new JsonException("Unknown number type: " + jsonType);
    }

    private Object readDouble(Type type) throws IOException {
        long bits = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
        bits <<= 32;
        double value = Double.longBitsToDouble(bits |= (long)this.read() << 24 | (long)(this.read() << 16) | (long)(this.read() << 8) | (long)this.read());
        int jsonType = ClassWrapper.getWrapper(type).getJsonType();
        switch (jsonType) {
            case 9: {
                return this.pool(value != 0.0);
            }
            case 10: {
                return this.pool((byte)value);
            }
            case 11: {
                return this.pool((short)value);
            }
            case 12: {
                return this.pool((int)value);
            }
            case 13: {
                return this.pool((long)value);
            }
            case 14: {
                return this.pool(Float.valueOf((float)value));
            }
            case 15: {
                return this.pool(value);
            }
            case 16: {
                return this.pool(Character.valueOf((char)value));
            }
        }
        throw new JsonException("Unknown number type: " + jsonType);
    }
}

