/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.i18n.Msg;
import java.text.DateFormat;
import java.util.Date;

@InternalApi
public class PDFCVersion {
    static final boolean IS_TECHNICAL_BUILD = true;
    static final Date CURRENT_DATE = new Date();
    public static final int VERSION_MAJOR = 20;
    public static final int VERSION_MINOR = 4;
    public static final int VERSION_BUILD = 0;
    public static final int YEAR = 2019;
    public static final String VERSION = "20.4.0";

    static String getVersion(boolean appendBeta, boolean appendValidTime) {
        Date betaExpiration;
        String version = VERSION;
        if (appendBeta && (betaExpiration = PDFCVersion.getBetaExpirationDate()) != null) {
            version = version + " Technical Build";
            if (appendValidTime) {
                version = version + " (" + Msg.getMsg("system.info.validUntil", DateFormat.getDateInstance(3).format(betaExpiration)) + ")";
            }
        }
        return version;
    }

    static Date getBetaExpirationDate() {
        java.sql.Date buildDate;
        try {
            buildDate = java.sql.Date.valueOf("{TODAY}");
        }
        catch (IllegalArgumentException e) {
            buildDate = new java.sql.Date(CURRENT_DATE.getTime());
        }
        return new Date(buildDate.getTime() + 7776000000L);
    }
}

