/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@InternalApi
public class PdfcImageIO {
    private static final String DIMENSION = "Dimension";
    private static final String TYPE_IMAGE_IO = "javax_imageio_1.0";
    private static final String VERTICAL_PIXEL_SIZE = "VerticalPixelSize";
    private static final String HORIZONTAL_PIXEL_SIZE = "HorizontalPixelSize";
    private static final String DENSITY_UNITS_PIXELS_PER_INCH = "1";
    private static final float DPI_TO_DPMM = 25.4f;

    public static ImageWithMeta readImage(File path) throws IOException {
        return PdfcImageIO.readImage(ImageIO.createImageInputStream(path));
    }

    public static ImageWithMeta readImage(InputStream in) throws IOException {
        return PdfcImageIO.readImage(ImageIO.createImageInputStream(in));
    }

    private static ImageWithMeta readImage(ImageInputStream iis) throws IOException {
        Node item;
        NamedNodeMap nnm;
        Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
        if (!it.hasNext()) {
            return null;
        }
        ImageReader reader = it.next();
        reader.setInput(iis);
        BufferedImage image = reader.read(0);
        int dpiX = -1;
        int dpiY = -1;
        IIOMetadata meta = reader.getImageMetadata(0);
        IIOMetadataNode root = (IIOMetadataNode)meta.getAsTree(TYPE_IMAGE_IO);
        NodeList nodes = root.getElementsByTagName(HORIZONTAL_PIXEL_SIZE);
        if (nodes.getLength() > 0) {
            IIOMetadataNode dpcWidth = (IIOMetadataNode)nodes.item(0);
            nnm = dpcWidth.getAttributes();
            item = nnm.item(0);
            dpiX = Math.round(25.4f / Float.parseFloat(item.getNodeValue()));
        }
        if (nodes.getLength() > 0) {
            nodes = root.getElementsByTagName(VERTICAL_PIXEL_SIZE);
            IIOMetadataNode dpcHeight = (IIOMetadataNode)nodes.item(0);
            nnm = dpcHeight.getAttributes();
            item = nnm.item(0);
            dpiY = Math.round(25.4f / Float.parseFloat(item.getNodeValue()));
        }
        int dpi = dpiX > 0 ? (dpiY > 0 ? (dpiX + dpiY) / 2 : dpiX) : (dpiY > 0 ? dpiY : -1);
        return new ImageWithMeta(image, dpi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeImage(BufferedImage image, int dpi, String format, Object out) throws IOException {
        if (!(out instanceof File) && !(out instanceof OutputStream)) {
            throw new IllegalArgumentException("The parameter 'out' has to be either a File or an OutputStream. A '" + out.getClass().getSimpleName() + "' is not allowe here");
        }
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(format);
        while (iw.hasNext()) {
            ImageWriter writer = iw.next();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            IIOMetadata metadata = writer.getDefaultImageMetadata(ImageTypeSpecifier.createFromBufferedImageType(image.getType()), writeParam);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            if ("png".equalsIgnoreCase(format)) {
                PdfcImageIO.setDPI_PNG(metadata, dpi);
            } else {
                if (image.getColorModel().getNumComponents() != 3 && image.getColorModel().getNumComponents() != 1) {
                    BufferedImage imageRGB = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                    Graphics g = imageRGB.getGraphics();
                    g.drawImage(image, 0, 0, null);
                    g.dispose();
                    image = imageRGB;
                    metadata = writer.getDefaultImageMetadata(ImageTypeSpecifier.createFromBufferedImageType(image.getType()), writeParam);
                }
                PdfcImageIO.setDPI_JPG(metadata, dpi);
            }
            try (ImageOutputStream stream = ImageIO.createImageOutputStream(out);){
                writer.setOutput(stream);
                writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                break;
            }
        }
    }

    private static void setDPI_PNG(IIOMetadata metadata, int DPI) throws IOException {
        double dotsPerMilli = (float)DPI / 25.4f;
        IIOMetadataNode horiz = new IIOMetadataNode(HORIZONTAL_PIXEL_SIZE);
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode(VERTICAL_PIXEL_SIZE);
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode(DIMENSION);
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode(TYPE_IMAGE_IO);
        root.appendChild(dim);
        metadata.mergeTree(TYPE_IMAGE_IO, root);
    }

    private static void setDPI_JPG(IIOMetadata metadata, int dpi) {
        String metadataFormat = "javax_imageio_jpeg_image_1.0";
        IIOMetadataNode root = new IIOMetadataNode(metadataFormat);
        IIOMetadataNode jpegVariety = new IIOMetadataNode("JPEGvariety");
        IIOMetadataNode markerSequence = new IIOMetadataNode("markerSequence");
        IIOMetadataNode app0JFIF = new IIOMetadataNode("app0JFIF");
        app0JFIF.setAttribute("majorVersion", DENSITY_UNITS_PIXELS_PER_INCH);
        app0JFIF.setAttribute("minorVersion", "2");
        app0JFIF.setAttribute("thumbWidth", "0");
        app0JFIF.setAttribute("thumbHeight", "0");
        app0JFIF.setAttribute("resUnits", DENSITY_UNITS_PIXELS_PER_INCH);
        app0JFIF.setAttribute("Xdensity", String.valueOf(dpi));
        app0JFIF.setAttribute("Ydensity", String.valueOf(dpi));
        root.appendChild(jpegVariety);
        root.appendChild(markerSequence);
        jpegVariety.appendChild(app0JFIF);
        try {
            metadata.mergeTree(metadataFormat, root);
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            // empty catch block
        }
    }

    @InternalApi
    public static class ImageWithMeta {
        private BufferedImage image;
        private int dpi;

        private ImageWithMeta(BufferedImage image, int dpi) {
            this.image = image;
            this.dpi = dpi;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public int getDPI() {
            return this.dpi;
        }
    }
}

