/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.rpc.model;

import com.inet.annotations.JsonData;

@JsonData
public class PageKey {
    private int pageIndex;
    private boolean first;

    public PageKey(String key) {
        String[] parts = key.split("-");
        this.pageIndex = Integer.parseInt(parts[1]);
        this.first = Boolean.parseBoolean(parts[2]);
    }

    public PageKey(int pageIndex, boolean first) {
        this.pageIndex = pageIndex;
        this.first = first;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public boolean isFirst() {
        return this.first;
    }

    public String getStringKey() {
        return "page-" + this.pageIndex + "-" + this.first;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PageKey)) {
            return false;
        }
        PageKey other = (PageKey)obj;
        return other.first == this.first && other.pageIndex == this.pageIndex;
    }

    public int hashCode() {
        return (this.first ? 100000 : 0) + this.pageIndex;
    }

    public String toString() {
        return this.getStringKey();
    }
}

