/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.annotations.JsonData;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonSubTypeResolver;
import com.inet.lib.util.DebugUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ClassWrapper {
    private static final Map<Type, ClassWrapper> CLASSES = new ConcurrentHashMap<Type, ClassWrapper>();
    private static final Type[] EMPTY_TYPE_ARGUMENTS = new Type[0];
    static final int JSON_NON_QUOTE = 1;
    static final int JSON_QUOTE = 2;
    static final int JSON_COLLECTION = 3;
    static final int JSON_MAP = 4;
    static final int JSON_ARRAY = 5;
    static final int JSON_ENUM = 6;
    static final int JSON_OBJECT = 7;
    static final int JSON_DATE = 8;
    static final int JSON_BOOLEAN = 9;
    static final int JSON_BYTE = 10;
    static final int JSON_SHORT = 11;
    static final int JSON_INTEGER = 12;
    static final int JSON_LONG = 13;
    static final int JSON_FLOAT = 14;
    static final int JSON_DOUBLE = 15;
    static final int JSON_CHAR = 16;
    static final int JSON_BYTES = 17;
    private final Class<?> clazz;
    private final Type type;
    private final Map<String, Field> fields = new ConcurrentHashMap<String, Field>();
    private Constructor<?> ctor;
    private int valueOfType;
    private Method valueOf;
    private JsonSubTypeResolver<?> subTypeResolver;
    private Field[] declaredFields;
    private int jsonType;
    private Type[] typeArguments;

    private ClassWrapper(Type type) {
        this.clazz = this.getClass(type);
        this.type = type;
    }

    static ClassWrapper getWrapper(Type type) {
        ClassWrapper wrapper = CLASSES.get(type);
        if (wrapper == null) {
            wrapper = type != Void.class ? new ClassWrapper(type) : new ClassWrapper(type){

                @Override
                Object create() throws JsonException {
                    return null;
                }
            };
            CLASSES.put(type, wrapper);
        }
        return wrapper;
    }

    Class<?> getClazz() {
        return this.clazz;
    }

    Field findField(final String name) {
        Field field = this.fields.get(name);
        if (field != null) {
            return field;
        }
        for (Field f : this.getDeclaredFields()) {
            this.fields.put(f.getName(), f);
        }
        field = this.fields.get(name);
        if (field != null) {
            return field;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                for (Class cla = ClassWrapper.this.clazz; cla != null; cla = cla.getSuperclass()) {
                    try {
                        Field field = cla.getDeclaredField(name);
                        field.setAccessible(true);
                        ClassWrapper.this.fields.put(name, field);
                        return field;
                    }
                    catch (NoSuchFieldException ex) {
                        continue;
                    }
                }
                return null;
            }
        });
    }

    private void valueOfInit() throws JsonException {
        if (this.clazz == Character.class || this.clazz == Character.TYPE) {
            this.valueOfType = 2;
        } else if (this.clazz == String.class) {
            this.valueOfType = 3;
        } else if (Enum.class.isAssignableFrom(this.clazz)) {
            this.valueOfType = 4;
        } else {
            try {
                this.valueOf = this.clazz.getMethod("valueOf", String.class);
                this.valueOfType = (this.valueOf.getModifiers() & 8) > 0 ? 1 : 3;
            }
            catch (Exception ex) {
                this.valueOfType = 3;
            }
        }
    }

    boolean hasValueOf() {
        if (this.valueOfType == 0) {
            this.valueOfInit();
        }
        return this.valueOfType == 1;
    }

    Object valueOf(String value, boolean fallBackToString) throws JsonException {
        switch (this.valueOfType) {
            default: {
                this.valueOfInit();
                return this.valueOf(value, fallBackToString);
            }
            case 1: {
                try {
                    return this.valueOf.invoke(null, value);
                }
                catch (Exception ex) {
                    throw (JsonException)new JsonException("Value '" + value + "' can't convert to type: " + this.clazz).initCause(ex);
                }
            }
            case 2: {
                return new Character(value.charAt(0));
            }
            case 3: {
                if (fallBackToString) {
                    return value;
                }
                switch (value) {
                    case "false": {
                        return Boolean.FALSE;
                    }
                    case "true": {
                        return Boolean.TRUE;
                    }
                }
                try {
                    return Integer.valueOf(value);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return Long.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new JsonException("Value '" + value + "' can't convert to type: " + this.clazz);
                    }
                }
            }
            case 4: 
        }
        return Enum.valueOf(this.clazz, value);
    }

    Object create() throws JsonException {
        try {
            if (this.ctor == null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            Constructor constructor = ClassWrapper.this.clazz.getDeclaredConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            Object obj = constructor.newInstance(new Object[0]);
                            ClassWrapper.this.ctor = constructor;
                            return obj;
                        }
                    });
                }
                catch (Exception ex) {
                    if (this.clazz.isAssignableFrom(ArrayList.class)) {
                        this.ctor = ArrayList.class.getConstructor(new Class[0]);
                    }
                    if (this.clazz.isAssignableFrom(Set.class)) {
                        this.ctor = HashSet.class.getConstructor(new Class[0]);
                    }
                    if (this.clazz.isAssignableFrom(Map.class)) {
                        this.ctor = HashMap.class.getConstructor(new Class[0]);
                    }
                    throw ex;
                }
            }
            return this.ctor.newInstance(new Object[0]);
        }
        catch (PrivilegedActionException ex) {
            throw JsonException.create(ex.getCause());
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    private Class<?> getClass(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return (Class)pType.getRawType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType aType = (GenericArrayType)type;
            type = aType.getGenericComponentType();
            return Array.newInstance(this.getClass(type), 0).getClass();
        }
        return (Class)type;
    }

    Field[] getDeclaredFields() {
        if (this.declaredFields == null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Field[] superFields;
                    int i;
                    String name = ClassWrapper.this.clazz.getName();
                    if (DebugUtils.DEBUG && !name.startsWith("java.") && !name.startsWith("javax.") && ClassWrapper.this.clazz.getAnnotation(JsonData.class) == null) {
                        throw new JsonException(ClassWrapper.this.clazz + " has no JsonData annotation");
                    }
                    Field[] fields = null;
                    try {
                        Method method = ClassWrapper.this.clazz.getMethod("getDeclaredFields", new Class[0]);
                        fields = (Field[])method.invoke(null, new Object[0]);
                    }
                    catch (Throwable method) {
                        // empty catch block
                    }
                    if (fields == null) {
                        fields = ClassWrapper.this.clazz.getDeclaredFields();
                    }
                    for (i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        if ((field.getModifiers() & 0x88) <= 0) continue;
                        Field[] copy = Arrays.copyOf(fields, fields.length - 1);
                        System.arraycopy(fields, i + 1, copy, i, copy.length - i);
                        fields = copy;
                        --i;
                    }
                    for (i = 0; i < fields.length; ++i) {
                        fields[i].setAccessible(true);
                    }
                    Class superClass = ClassWrapper.this.clazz.getSuperclass();
                    if (superClass != null && (superFields = ClassWrapper.getWrapper(superClass).getDeclaredFields()).length > 0) {
                        int length = superFields.length;
                        superFields = Arrays.copyOf(superFields, length + fields.length);
                        System.arraycopy(fields, 0, superFields, length, fields.length);
                        fields = superFields;
                    }
                    if (DebugUtils.DEBUG && fields.length > 0) {
                        HashSet<String> set = new HashSet<String>();
                        for (Field field : fields) {
                            if (set.add(field.getName())) continue;
                            throw new JsonException(ClassWrapper.this.clazz + " has a duplicate field: " + field.getName());
                        }
                    }
                    ClassWrapper.access$402(ClassWrapper.this, fields);
                    return null;
                }
            });
        }
        return this.declaredFields;
    }

    int getJsonType() {
        if (this.jsonType == 0) {
            this.jsonType = Boolean.class == this.clazz || Boolean.TYPE == this.clazz ? 9 : (Byte.class == this.clazz || Byte.TYPE == this.clazz ? 10 : (Short.class == this.clazz || Short.TYPE == this.clazz ? 11 : (Integer.class == this.clazz || Integer.TYPE == this.clazz ? 12 : (Long.class == this.clazz || Long.TYPE == this.clazz ? 13 : (Float.class == this.clazz || Float.TYPE == this.clazz ? 14 : (Double.class == this.clazz || Double.TYPE == this.clazz ? 15 : (Number.class.isAssignableFrom(this.clazz) ? 1 : (Collection.class.isAssignableFrom(this.clazz) ? 3 : (Map.class.isAssignableFrom(this.clazz) ? 4 : (String.class == this.clazz ? 2 : (Character.class == this.clazz || Character.TYPE == this.clazz ? 16 : (byte[].class == this.clazz ? 17 : (this.clazz.isArray() ? 5 : (Enum.class.isAssignableFrom(this.clazz) ? 6 : (Date.class == this.clazz ? 8 : (this.hasValueOf() ? 2 : (CharSequence.class.isAssignableFrom(this.clazz) ? 2 : 7)))))))))))))))));
        }
        return this.jsonType;
    }

    Type[] getTypeArguments() {
        if (this.typeArguments == null) {
            Type[] typeArguments;
            if (this.type instanceof ParameterizedType) {
                typeArguments = ((ParameterizedType)this.type).getActualTypeArguments();
                try {
                    for (Type typeArg : typeArguments) {
                        ClassWrapper.getWrapper(typeArg);
                    }
                }
                catch (Exception ex) {
                    typeArguments = EMPTY_TYPE_ARGUMENTS;
                }
            } else {
                Type superType = this.clazz.getGenericSuperclass();
                if (superType != null) {
                    ClassWrapper wrapper = ClassWrapper.getWrapper(superType);
                    typeArguments = wrapper.getTypeArguments();
                    if (typeArguments == null) {
                        typeArguments = EMPTY_TYPE_ARGUMENTS;
                    }
                } else {
                    typeArguments = EMPTY_TYPE_ARGUMENTS;
                }
            }
            this.typeArguments = typeArguments;
        }
        if (this.typeArguments.length == 0) {
            return null;
        }
        return this.typeArguments;
    }

    boolean hasGetTypeFor() {
        return this.subTypeResolver != null;
    }

    void setSubTypeResolver(JsonSubTypeResolver<?> resolver) {
        this.subTypeResolver = resolver;
    }

    Type getTypeFor(Map<String, Object> fieldValues, HashMap<String, Object> extraFieldValues) throws JsonException {
        return this.subTypeResolver.getTypeFor(fieldValues, extraFieldValues);
    }

    static /* synthetic */ Field[] access$402(ClassWrapper x0, Field[] x1) {
        x0.declaredFields = x1;
        return x1;
    }
}

