/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;

public class FastByteArrayOutputStream
extends OutputStream {
    private LinkedList<byte[]> buffers;
    private byte[] buffer;
    private int index;
    private int size;

    public FastByteArrayOutputStream() {
        this(8192);
    }

    public FastByteArrayOutputStream(int blockSize) {
        this.buffer = new byte[blockSize];
    }

    public int size() {
        return this.size + this.index;
    }

    @Override
    public void close() {
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.size()];
        int pos = 0;
        if (this.buffers != null) {
            for (byte[] bytes : this.buffers) {
                System.arraycopy(bytes, 0, data, pos, bytes.length);
                pos += bytes.length;
            }
        }
        System.arraycopy(this.buffer, 0, data, pos, this.index);
        return data;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), charset);
    }

    @Override
    public void write(int datum) {
        if (this.index == this.buffer.length) {
            this.addBuffer(1);
        }
        this.buffer[this.index++] = (byte)datum;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] data, int offset, int length) {
        if (offset < 0 || offset + length > data.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        int blockSize = this.buffer.length;
        if (this.index + length > blockSize) {
            int copyLength;
            do {
                if (this.index == blockSize) {
                    this.addBuffer(length);
                    blockSize = this.buffer.length;
                }
                if (length < (copyLength = blockSize - this.index)) {
                    copyLength = length;
                }
                System.arraycopy(data, offset, this.buffer, this.index, copyLength);
                offset += copyLength;
                this.index += copyLength;
            } while ((length -= copyLength) > 0);
        } else {
            System.arraycopy(data, offset, this.buffer, this.index, length);
            this.index += length;
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.buffers != null) {
            for (byte[] bytes : this.buffers) {
                out.write(bytes, 0, bytes.length);
            }
        }
        out.write(this.buffer, 0, this.index);
    }

    protected void addBuffer(int minNeeded) {
        if (this.buffers == null) {
            this.buffers = new LinkedList();
        }
        this.buffers.addLast(this.buffer);
        this.size += this.buffer.length;
        int newCapacity = this.buffer.length << 1;
        if (newCapacity < minNeeded) {
            newCapacity = minNeeded;
        }
        this.buffer = new byte[newCapacity];
        this.index = 0;
    }

    public void reset() {
        this.index = 0;
        this.size = 0;
        this.buffers = null;
    }
}

