/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import java.util.Arrays;

@JsonData
@InternalApi
public class ElementID
implements Comparable<ElementID> {
    public static final ElementID DUMMY = new ElementID();
    private int[] idLevels;

    private ElementID() {
    }

    public ElementID(int id) {
        this.idLevels = new int[]{id};
    }

    public ElementID(int[] idLevels) {
        this.idLevels = new int[idLevels.length];
        System.arraycopy(idLevels, 0, this.idLevels, 0, idLevels.length);
    }

    public int[] getRaw() {
        int[] copy = new int[this.idLevels.length];
        System.arraycopy(this.idLevels, 0, copy, 0, this.idLevels.length);
        return copy;
    }

    public ElementID getNext() {
        ElementID copy = new ElementID(this.idLevels);
        int n = copy.idLevels.length - 1;
        copy.idLevels[n] = copy.idLevels[n] + 1;
        return copy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElementID)) {
            return false;
        }
        return Arrays.equals(this.idLevels, ((ElementID)obj).idLevels);
    }

    public int hashCode() {
        return Arrays.hashCode(this.idLevels);
    }

    @Override
    public int compareTo(ElementID o) {
        int common = Math.min(this.idLevels.length, o.idLevels.length);
        for (int i = 0; i < common; ++i) {
            int compare = Integer.compare(this.idLevels[i], o.idLevels[i]);
            if (compare == 0) continue;
            return compare;
        }
        if (this.idLevels.length == o.idLevels.length) {
            return 0;
        }
        return o.idLevels.length - this.idLevels.length;
    }

    public ElementID getDescendant() {
        return this.getDescendant(0);
    }

    public ElementID getDescendant(int descendantID) {
        ElementID descendant = new ElementID();
        descendant.idLevels = new int[this.idLevels.length + 1];
        System.arraycopy(this.idLevels, 0, descendant.idLevels, 0, this.idLevels.length);
        descendant.idLevels[descendant.idLevels.length - 1] = descendantID;
        return descendant;
    }

    public String toString() {
        if (this.idLevels.length == 1) {
            return Integer.toString(this.idLevels[0]);
        }
        StringBuilder b = new StringBuilder();
        for (int level : this.idLevels) {
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(level);
        }
        return b.toString();
    }

    public static ElementID valueOf(String value) {
        String[] parts = value.split(",");
        int[] levels = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            levels[i] = Integer.parseInt(parts[i]);
        }
        return new ElementID(levels);
    }

    static {
        ElementID.DUMMY.idLevels = new int[]{0};
    }
}

