/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.model.ModificationFormatter;
import com.inet.pdfc.generator.model.diff.AttributeDifference;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class ModificationFormatterGUI
extends ModificationFormatter {
    private boolean merge;

    public ModificationFormatterGUI(boolean merge) {
        this.merge = merge;
    }

    @Override
    protected String getContent(List<PagedElement> elements, boolean isText) {
        String content = super.getContent(elements, isText);
        if (this.merge && content.startsWith("'") && content.endsWith("'")) {
            return content.substring(1, content.length() - 1);
        }
        return content;
    }

    @Override
    public String format(Modification m) {
        String modifications;
        Modification.ModificationType modType;
        if (m == null) {
            return null;
        }
        if (!this.merge) {
            return super.format(m);
        }
        List<PagedElement> first = m.getAffectedElements(true);
        List<PagedElement> second = m.getAffectedElements(false);
        ElementType typeFirst = this.getBaseType(first);
        ElementType typeSecond = this.getBaseType(second);
        boolean firstIsText = typeFirst == ElementType.Text;
        boolean secondIsText = typeSecond == ElementType.Text;
        boolean isText = firstIsText || secondIsText;
        String plural = first.size() > 1 && !isText && !m.isShouldPageElementMerge() ? ".plural" : ".singular";
        String contentFirst = firstIsText ? this.getContent(first, true) : this.count(typeFirst, first.size());
        String contentSecond = secondIsText ? this.getContent(second, true) : this.count(typeSecond, second.size());
        AttributeDifference<?> locationChange = isText ? this.getLocationChange(m) : null;
        Modification.ModificationType modificationType = modType = locationChange != null ? Modification.ModificationType.attributeDifference : m.getModificationType();
        if (m.isShouldPageElementMerge()) {
            ArrayList<PagedElement> pagedElements;
            if (!first.isEmpty()) {
                pagedElements = new ArrayList<PagedElement>();
                pagedElements.add(first.get(0));
                contentFirst = this.getContent(pagedElements, firstIsText);
            }
            if (!second.isEmpty()) {
                pagedElements = new ArrayList();
                pagedElements.add(second.get(0));
                contentSecond = this.getContent(pagedElements, secondIsText);
            }
            return Msg.getMsg("Modification.short." + (Object)((Object)modType) + plural, "", contentFirst, contentSecond, "");
        }
        List<AttributeDifference<?>> changes = m.getAttributeDifferences();
        if (locationChange != null) {
            changes = new ArrayList(changes);
            changes.remove(locationChange);
            changes.add(locationChange);
            modifications = this.getModifications(changes);
            String position = this.getPosition(first, second);
            modifications = modifications + position;
        } else {
            modifications = this.getModifications(changes);
        }
        if (changes != null && !changes.isEmpty()) {
            return modifications;
        }
        return Msg.getMsg("Modification.short." + (Object)((Object)modType) + plural, contentFirst, contentSecond, modifications).trim();
    }

    protected String count(ElementType type, int count) {
        String typeName = type != null ? type.name() : "Element";
        return count > 1 ? count + " " + Msg.getMsg("Type." + typeName + ".Plural") : Msg.getMsg("Prefix." + typeName + ".singular");
    }
}

