/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.FastStringReader;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParser;
import com.inet.lib.json.JsonTypeResolver;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

abstract class BaseParser {
    private final Map<Object, Map<String, Object>> extraFields;
    final JsonTypeResolver typeResolver;
    private final Function<Object, Object> objectPool;

    BaseParser(Map<Object, Map<String, Object>> extraFields, JsonTypeResolver typeResolver, Function<Object, Object> objectPool) {
        this.extraFields = extraFields;
        this.typeResolver = typeResolver;
        this.objectPool = objectPool;
    }

    <T> T pool(T obj) {
        return (T)this.objectPool.apply(obj);
    }

    void saveExtraField(Object obj, String fieldName) throws JsonException, IOException {
        this.saveExtraField(obj, fieldName, null, true);
    }

    void saveExtraField(Object obj, String fieldName, Object value, boolean valueNeedParse) throws JsonException, IOException {
        if (this.extraFields == null) {
            throw new JsonException("Field '" + fieldName + "' not found in " + obj.getClass().getName() + ".");
        }
        Map<String, Object> extras = this.extraFields.get(obj);
        if (extras == null) {
            extras = new HashMap<String, Object>();
            this.extraFields.put(obj, extras);
        }
        if (valueNeedParse) {
            value = this.parseExtraFieldValue();
        }
        extras.put(fieldName, value);
    }

    abstract Object parseExtraFieldValue() throws JsonException, IOException;

    class JsonObject {
        private ClassWrapper wrapper;
        HashMap<String, Object> fieldValues = new HashMap();
        HashMap<String, Object> extraFieldValues = new HashMap();

        JsonObject(ClassWrapper wrapper) {
            this.wrapper = wrapper;
        }

        Object create() throws IOException {
            this.wrapper = ClassWrapper.getWrapper(this.wrapper.getTypeFor(this.fieldValues, this.extraFieldValues));
            Object obj = this.wrapper.create();
            this.setFields(obj, this.fieldValues.entrySet(), false);
            this.setFields(obj, this.extraFieldValues.entrySet(), true);
            return obj;
        }

        private void setFields(Object obj, Set entrySet, boolean isExtra) throws IOException {
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                Field field = this.wrapper.findField(key);
                Object value = entry.getValue();
                if (field == null) {
                    BaseParser.this.saveExtraField(obj, key, String.valueOf(value), false);
                    continue;
                }
                Type fieldType = BaseParser.this.typeResolver.getGenericType(obj, field);
                if (isExtra && BaseParser.this.getClass() == JsonParser.class) {
                    JsonParser parser = new JsonParser(new FastStringReader((String)value), BaseParser.this.extraFields, BaseParser.this.typeResolver);
                    value = parser.parseValue(fieldType);
                }
                try {
                    field.set(obj, value);
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }
}

