/*
 * Decompiled with CFR 0.152.
 */
package com.inet.excel;

import com.inet.excel.ExcelDriver;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ExcelResultSet
implements ResultSet {
    private final List<String> columnNames;

    public ExcelResultSet(List<String> columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException("list of column names must not be null");
        }
        this.columnNames = Collections.unmodifiableList(columnNames);
    }

    protected abstract <T> T getValue(int var1) throws SQLException;

    protected void throwIfAlreadyClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet: already closed");
        }
    }

    protected void throwIfAlreadyClosedOrReachedEnd() throws SQLException {
        this.throwIfAlreadyClosed();
        if (this.isAfterLast()) {
            throw new SQLException("ResultSet: already reached end");
        }
    }

    protected void throwIfColumnIndexIsInvalid(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.columnNames.size()) {
            throw new SQLException("ResultSet: invalid column index " + columnIndex + " for column count " + this.columnNames.size());
        }
    }

    protected void throwExceptionDueToConcurrencyMode() throws SQLException {
        throw new SQLException("Data may not be updated using this result set");
    }

    protected void throwExceptionDueToResultSetType() throws SQLException {
        throw new SQLException("Operation is not allowed on result set of type \"TYPE_FORWARD_ONLY\"");
    }

    protected List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object value = this.getValue(columnIndex);
        return value != null ? value.toString() : null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Boolean value = (Boolean)this.getValue(columnIndex);
        if (value == null) {
            return false;
        }
        return value;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Number value = (Number)this.getValue(columnIndex);
        if (value == null) {
            return 0;
        }
        return value.byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Number value = (Number)this.getValue(columnIndex);
        if (value == null) {
            return 0;
        }
        return value.shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Number value = (Number)this.getValue(columnIndex);
        if (value == null) {
            return 0;
        }
        return value.intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Number value = (Number)this.getValue(columnIndex);
        if (value == null) {
            return 0L;
        }
        return value.longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Number value = (Number)this.getValue(columnIndex);
        if (value == null) {
            return 0.0f;
        }
        return value.floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Number value = (Number)this.getValue(columnIndex);
        if (value == null) {
            return 0.0;
        }
        return value.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)this.getValue(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.getValue(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.getValue(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.getValue(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.getValue(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getByte(columnIndex);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getShort(columnIndex);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getInt(columnIndex);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getLong(columnIndex);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getFloat(columnIndex);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBytes(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getDate(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getValue(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getObject(columnIndex);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.throwIfAlreadyClosed();
        for (int index = 0; index < this.columnNames.size(); ++index) {
            if (!Objects.equals(columnLabel, this.columnNames.get(index))) continue;
            return index + 1;
        }
        throw new SQLException("ResultSet: unknown column \"" + columnLabel + "\".");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.getValue(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object value = this.getValue(columnIndex);
        if (value == null) {
            return null;
        }
        return new BigDecimal(value.toString());
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.throwExceptionDueToResultSetType();
    }

    @Override
    public void afterLast() throws SQLException {
        this.throwExceptionDueToResultSetType();
    }

    @Override
    public boolean first() throws SQLException {
        this.throwExceptionDueToResultSetType();
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.throwExceptionDueToResultSetType();
        return false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.throwExceptionDueToResultSetType();
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.throwExceptionDueToResultSetType();
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        this.throwExceptionDueToResultSetType();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void insertRow() throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateRow() throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.throwExceptionDueToResultSetType();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public Statement getStatement() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.throwIfAlreadyClosed();
        return 1;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.throwExceptionDueToConcurrencyMode();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getObject(columnIndex, type);
    }
}

