/*
 * Decompiled with CFR 0.152.
 */
package com.inet.excel;

import com.inet.excel.ExcelCallableStatement;
import com.inet.excel.ExcelDatabaseMetaData;
import com.inet.excel.ExcelDriver;
import com.inet.excel.parser.ExcelParser;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ExcelConnection
implements Connection {
    private final ExcelParser parser;
    private boolean closed;
    private Runnable onConnectionClose;

    public ExcelConnection(ExcelParser parser, Runnable onConnectionClose) {
        if (parser == null) {
            throw new IllegalArgumentException("parser must not be null");
        }
        this.parser = parser;
        this.onConnectionClose = onConnectionClose;
        this.closed = false;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new ExcelDatabaseMetaData(this.parser);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public Statement createStatement() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.throwIfAlreadyClosed();
        String procedureName = null;
        if (sql != null && sql.startsWith("{call ")) {
            if (sql.endsWith("()}")) {
                procedureName = sql.substring(6, sql.length() - 3);
            } else if (sql.endsWith("}")) {
                procedureName = sql.substring(6, sql.length() - 1);
            }
        }
        if (procedureName != null) {
            return new ExcelCallableStatement(this.parser, procedureName);
        }
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public void commit() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public void rollback() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed && this.onConnectionClose != null) {
            this.onConnectionClose.run();
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.throwIfAlreadyClosed();
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.parser.getFileName();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.throwIfAlreadyClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwIfAlreadyClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfAlreadyClosed();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public int getHoldability() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return 0;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public String getSchema() throws SQLException {
        this.throwIfAlreadyClosed();
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.throwIfAlreadyClosed();
        return 0;
    }

    private void throwIfAlreadyClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection: already closed");
        }
    }
}

