/*
 * Decompiled with CFR 0.152.
 */
package com.inet.excel.parser;

import com.inet.excel.parser.FormatCodeAnalyzer;
import com.inet.excel.parser.RowData;
import com.inet.excel.parser.RowSpanData;
import com.inet.excel.parser.SheetDimension;
import com.inet.excel.parser.ValueType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ExcelParser {
    private final XMLInputFactory factory = XMLInputFactory.newInstance();
    private final Path filePath;
    private final boolean hasHeaderRow;
    private List<String> sharedStrings = null;
    private Map<String, String> sheetNamesToPaths = null;
    private List<ValueType> valueTypesOrderedByStyleIndexes = null;
    private Map<String, SheetDimension> sheetNamesToDimensions = new HashMap<String, SheetDimension>();
    private Map<String, List<String>> sheetNamesToColumnNames = new HashMap<String, List<String>>();
    private Map<String, List<ValueType>> sheetNamesToColumnTypes = new HashMap<String, List<ValueType>>();

    public ExcelParser(Path filePath, boolean hasHeaderRow) {
        if (filePath == null) {
            throw new IllegalArgumentException("filePath must not be null");
        }
        this.filePath = filePath;
        this.hasHeaderRow = hasHeaderRow;
    }

    public String getFileName() {
        return this.filePath.getFileName().toString();
    }

    public List<String> getColumnNames(String sheetName) {
        List<String> list;
        ZipFile zipFile = new ZipFile(this.filePath.toString());
        try {
            this.initSheetData(zipFile);
            this.initDimensionAndColumnNames(zipFile, sheetName);
            list = Collections.unmodifiableList(this.sheetNamesToColumnNames.get(sheetName));
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ExcelParserException(ex);
            }
        }
        zipFile.close();
        return list;
    }

    public List<String> getSheetNames() {
        List<String> list;
        ZipFile zipFile = new ZipFile(this.filePath.toString());
        try {
            this.initSheetData(zipFile);
            list = this.sheetNamesToPaths.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ExcelParserException(ex);
            }
        }
        zipFile.close();
        return list;
    }

    public List<ValueType> getColumnTypes(String sheetName) {
        List<ValueType> list;
        ZipFile zipFile = new ZipFile(this.filePath.toString());
        try {
            this.initSheetData(zipFile);
            this.initStyles(zipFile);
            this.initDimensionAndColumnNames(zipFile, sheetName);
            this.initColumnTypes(zipFile, sheetName);
            list = Collections.unmodifiableList(this.sheetNamesToColumnTypes.get(sheetName));
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ExcelParserException(ex);
            }
        }
        zipFile.close();
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRowCount(String sheetName) {
        try (ZipFile zipFile = new ZipFile(this.filePath.toString());){
            this.initSheetData(zipFile);
            int rowCount = this.readRowCount(zipFile, sheetName);
            if (this.hasHeaderRow) {
                int n = Math.max(0, rowCount - 1);
                return n;
            }
            int n = rowCount;
            return n;
        }
        catch (IOException ex) {
            throw new ExcelParserException(ex);
        }
    }

    public List<List<Object>> getRows(String sheetName, int firstRowIndex, int lastRowIndex) {
        List<List<Object>> list;
        if (firstRowIndex < 1) {
            throw new IllegalArgumentException("firstRowIndex must be greater than zero");
        }
        if (lastRowIndex < 1) {
            throw new IllegalArgumentException("lastRowIndex must be greater than zero");
        }
        if (firstRowIndex > lastRowIndex) {
            throw new IllegalArgumentException("firstRowIndex  must be smaller than or equal to lastRowIndex");
        }
        ZipFile zipFile = new ZipFile(this.filePath.toString());
        try {
            this.initSheetData(zipFile);
            this.initStyles(zipFile);
            this.initDimensionAndColumnNames(zipFile, sheetName);
            if (this.hasHeaderRow) {
                ++firstRowIndex;
                ++lastRowIndex;
            }
            list = this.readRows(zipFile, sheetName, firstRowIndex, lastRowIndex);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ExcelParserException(ex);
            }
        }
        zipFile.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSheetData(ZipFile zipFile) {
        if (this.sheetNamesToPaths != null) {
            return;
        }
        try {
            HashMap<String, String> sheetRelIdToName = new HashMap<String, String>();
            ZipEntry workbookEntry = zipFile.getEntry("xl/workbook.xml");
            try (InputStream is = zipFile.getInputStream(workbookEntry);
                 XMLStreamReader reader = this.factory.createXMLStreamReader(is);){
                while (reader.hasNext()) {
                    reader.next();
                    if (reader.getEventType() != 1 || !"sheet".equals(reader.getLocalName())) continue;
                    String rID = reader.getAttributeValue(null, "id");
                    String sheetName = reader.getAttributeValue(null, "name");
                    if (rID == null || sheetName == null) continue;
                    sheetRelIdToName.put(rID, sheetName);
                }
            }
            ZipEntry relsEntry = zipFile.getEntry("xl/_rels/workbook.xml.rels");
            try (InputStream is = zipFile.getInputStream(relsEntry);
                 XMLStreamReader reader = this.factory.createXMLStreamReader(is);){
                HashMap<String, String> map = new HashMap<String, String>();
                HashSet sheetRelIds = new HashSet(sheetRelIdToName.keySet());
                while (!sheetRelIds.isEmpty() && reader.hasNext()) {
                    String rID;
                    reader.next();
                    if (reader.getEventType() != 1 || !sheetRelIds.contains(rID = reader.getAttributeValue(null, "Id"))) continue;
                    sheetRelIds.remove(rID);
                    String sheetName = (String)sheetRelIdToName.get(rID);
                    String target = reader.getAttributeValue(null, "Target");
                    if (target == null) {
                        String msg = "Relationship of sheet \"" + sheetName + "\" must include attribute \"Target\".";
                        throw new ExcelParserException(new IllegalStateException(msg));
                    }
                    map.put(sheetName, "xl/" + target);
                }
                this.sheetNamesToPaths = map;
            }
        }
        catch (IOException | XMLStreamException ex) {
            throw new ExcelParserException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSharedStrings(ZipFile zipFile) {
        if (this.sharedStrings != null) {
            return;
        }
        ZipEntry sheetEntry = zipFile.getEntry("xl/sharedStrings.xml");
        try (InputStream is = zipFile.getInputStream(sheetEntry);
             XMLStreamReader reader = this.factory.createXMLStreamReader(is);){
            ArrayList<String> list = new ArrayList<String>();
            while (reader.hasNext()) {
                String localName;
                reader.next();
                if (reader.getEventType() != 1 || !"t".equals(localName = reader.getLocalName())) continue;
                list.add(reader.getElementText());
            }
            this.sharedStrings = list;
        }
        catch (IOException | XMLStreamException ex) {
            throw new ExcelParserException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStyles(ZipFile zipFile) {
        if (this.valueTypesOrderedByStyleIndexes != null) {
            return;
        }
        ZipEntry sheetEntry = zipFile.getEntry("xl/styles.xml");
        try (InputStream is = zipFile.getInputStream(sheetEntry);
             XMLStreamReader reader = this.factory.createXMLStreamReader(is);){
            boolean insideNumFmts = false;
            HashMap<String, String> numFmtIdToFormatCode = new HashMap<String, String>();
            boolean insideCellXfs = false;
            ArrayList<String> numFmtIdsFromCellXfs = new ArrayList<String>();
            while (reader.hasNext()) {
                String localName;
                reader.next();
                if (reader.getEventType() == 1) {
                    localName = reader.getLocalName();
                    if (localName == null) continue;
                    switch (localName) {
                        case "numFmts": {
                            insideNumFmts = true;
                            break;
                        }
                        case "numFmt": {
                            String numFmtId;
                            if (!insideNumFmts || (numFmtId = reader.getAttributeValue(null, "numFmtId")) == null) break;
                            String formatCode = reader.getAttributeValue(null, "formatCode");
                            if (formatCode == null) {
                                formatCode = "";
                            }
                            numFmtIdToFormatCode.put(numFmtId, formatCode);
                            break;
                        }
                        case "cellXfs": {
                            insideCellXfs = true;
                            break;
                        }
                        case "xf": {
                            if (!insideCellXfs) break;
                            String id = reader.getAttributeValue(null, "numFmtId");
                            if (id == null) {
                                id = "unknown";
                            }
                            numFmtIdsFromCellXfs.add(id);
                        }
                    }
                    continue;
                }
                if (reader.getEventType() != 2) continue;
                switch (localName = reader.getLocalName()) {
                    case "numFmts": {
                        insideNumFmts = false;
                        break;
                    }
                    case "cellXfs": {
                        insideCellXfs = false;
                    }
                }
            }
            this.valueTypesOrderedByStyleIndexes = new ArrayList<ValueType>();
            block38: for (int styleIndex = 0; styleIndex < numFmtIdsFromCellXfs.size(); ++styleIndex) {
                String id = (String)numFmtIdsFromCellXfs.get(styleIndex);
                try {
                    int intID = Integer.parseInt(id);
                    switch (intID) {
                        case 14: 
                        case 22: {
                            this.valueTypesOrderedByStyleIndexes.add(ValueType.TIMESTAMP);
                            continue block38;
                        }
                        case 15: 
                        case 16: 
                        case 17: {
                            this.valueTypesOrderedByStyleIndexes.add(ValueType.DATE);
                            continue block38;
                        }
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: {
                            this.valueTypesOrderedByStyleIndexes.add(ValueType.TIME);
                            continue block38;
                        }
                    }
                }
                catch (NumberFormatException intID) {
                    // empty catch block
                }
                String formatCode = numFmtIdToFormatCode.getOrDefault(id, "");
                this.valueTypesOrderedByStyleIndexes.add(FormatCodeAnalyzer.recognizeValueType(formatCode));
            }
        }
        catch (IOException | XMLStreamException ex) {
            throw new ExcelParserException(ex);
        }
    }

    private ZipEntry getZipEntryForSheet(ZipFile zipFile, String sheetName) {
        if (sheetName == null) {
            throw new ExcelParserException(new IllegalArgumentException("Sheet name must not be null."));
        }
        ZipEntry sheetEntry = null;
        String sheetPath = this.sheetNamesToPaths.get(sheetName);
        if (sheetPath != null) {
            sheetEntry = zipFile.getEntry(sheetPath);
        }
        if (sheetEntry == null) {
            String msg = "There is no sheet with name \"" + sheetName + "\".";
            throw new ExcelParserException(new IllegalArgumentException(msg));
        }
        return sheetEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void initDimensionAndColumnNames(ZipFile zipFile, String sheetName) {
        if (this.sheetNamesToDimensions.get(sheetName) != null && this.sheetNamesToColumnNames.get(sheetName) != null) {
            return;
        }
        try {
            sheetEntry = this.getZipEntryForSheet(zipFile, sheetName);
            is = zipFile.getInputStream(sheetEntry);
            try {
                block35: {
                    reader = this.factory.createXMLStreamReader(is);
                    insideHeaderRow = false;
                    collectCellRefs = false;
                    headerData = new RowData(1);
                    currentCellData = null;
                    sheetDimension = null;
                    rowSpan = new RowSpanData();
                    while (reader.hasNext()) {
                        reader.next();
                        if (reader.getEventType() == 1) {
                            localName = reader.getLocalName();
                            if (localName == null) continue;
                            var13_16 = localName;
                            var14_17 = -1;
                            switch (var13_16.hashCode()) {
                                case -1095013018: {
                                    if (!var13_16.equals("dimension")) break;
                                    var14_17 = 0;
                                    break;
                                }
                                case 113114: {
                                    if (!var13_16.equals("row")) break;
                                    var14_17 = 1;
                                    break;
                                }
                                case 99: {
                                    if (!var13_16.equals("c")) break;
                                    var14_17 = 2;
                                    break;
                                }
                                case 118: {
                                    if (!var13_16.equals("v")) break;
                                    var14_17 = 3;
                                }
                            }
                            switch (var14_17) {
                                case 0: {
                                    ref = reader.getAttributeValue(null, "ref");
                                    sheetDimension = SheetDimension.parse(ref);
                                    break;
                                }
                                case 1: {
                                    collectCellRefs = false;
                                    if (this.hasHeaderRow && "1".equals(rowIndex = reader.getAttributeValue(null, "r"))) {
                                        insideHeaderRow = true;
                                    }
                                    if (sheetDimension != null) break;
                                    spans = reader.getAttributeValue(null, "spans");
                                    if (spans == null) {
                                        collectCellRefs = true;
                                        break;
                                    }
                                    rowSpan.addSpanRange(spans);
                                    break;
                                }
                                case 2: {
                                    if (insideHeaderRow) {
                                        currentCellData = new RowData.CellData();
                                        currentCellData.setR(reader.getAttributeValue(null, "r"));
                                        currentCellData.setT(reader.getAttributeValue(null, "t"));
                                        currentCellData.setS(reader.getAttributeValue(null, "s"));
                                    }
                                    if (!collectCellRefs) break;
                                    cellRef = reader.getAttributeValue(null, "r");
                                    rowSpan.addCellRef(cellRef);
                                    break;
                                }
                                case 3: {
                                    if (!insideHeaderRow) break;
                                    currentCellData.setV(reader.getElementText());
                                    headerData.addCellData(currentCellData);
                                    currentCellData = null;
                                }
                            }
                        } else if (reader.getEventType() == 2) {
                            localName = reader.getLocalName();
                            if (insideHeaderRow && "row".equals(localName)) {
                                insideHeaderRow = false;
                            }
                        }
                        if (this.hasHeaderRow || sheetDimension == null) continue;
                    }
                    if (sheetDimension != null) ** GOTO lbl87
                    if (!rowSpan.isEmpty()) break block35;
                    this.sheetNamesToDimensions.put(sheetName, new SheetDimension(1, 1));
                    this.sheetNamesToColumnNames.put(sheetName, Collections.singletonList("C1"));
                    reader.close();
                    return;
                }
                try {
                    sheetDimension = new SheetDimension(rowSpan.getFirstColumnIndex(), rowSpan.getLastColumnIndex());
lbl87:
                    // 2 sources

                    columnNames = this.generateColumnNames(sheetDimension.getFirstColumnIndex(), sheetDimension.getLastColumnIndex());
                    for (RowData.CellData cell : headerData.getCellsInRow()) {
                        value = this.getCellValue(zipFile, cell);
                        if (value == null || (columnIndex = SheetDimension.getColumnIndexFromCellRef(cell.getR())) <= 0 || (columnIndex -= sheetDimension.getFirstColumnIndex()) < 0 || columnIndex >= columnNames.size()) continue;
                        columnNames.set(columnIndex, value.toString());
                    }
                    this.sheetNamesToDimensions.put(sheetName, sheetDimension);
                    this.sheetNamesToColumnNames.put(sheetName, columnNames);
                }
                catch (Throwable var17_24) {
                    reader.close();
                    throw var17_24;
                }
                reader.close();
                return;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException | XMLStreamException ex) {
            throw new ExcelParserException(ex);
        }
    }

    private List<String> generateColumnNames(int firstColumnIndex, int lastColumnIndex) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int index = firstColumnIndex; index <= lastColumnIndex; ++index) {
            columnNames.add("C" + index);
        }
        return columnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumnTypes(ZipFile zipFile, String sheetName) {
        if (this.sheetNamesToColumnTypes.get(sheetName) != null) {
            return;
        }
        try {
            ZipEntry sheetEntry = this.getZipEntryForSheet(zipFile, sheetName);
            try (InputStream is = zipFile.getInputStream(sheetEntry);
                 XMLStreamReader reader = this.factory.createXMLStreamReader(is);){
                int columnCount = this.sheetNamesToColumnNames.get(sheetName).size();
                SheetDimension sheetDimension = this.sheetNamesToDimensions.get(sheetName);
                int probedCellLimit = 10;
                int probedRowLimit = 30;
                int[] probedCells = new int[columnCount];
                ValueType[] valueTypes = new ValueType[columnCount];
                int probedRowCount = 0;
                boolean insideRow = false;
                ValueType typeToSet = null;
                Optional<Object> columnIndexOfValueToCheck = Optional.empty();
                boolean possibleNumber = false;
                block24: while (reader.hasNext()) {
                    String localName;
                    reader.next();
                    if (reader.getEventType() == 1) {
                        localName = reader.getLocalName();
                        if (localName == null) continue;
                        switch (localName) {
                            case "row": {
                                String rowIndex;
                                if (this.hasHeaderRow && "1".equals(rowIndex = reader.getAttributeValue(null, "r"))) break;
                                insideRow = true;
                                break;
                            }
                            case "c": {
                                if (!insideRow) break;
                                columnIndexOfValueToCheck = Optional.empty();
                                possibleNumber = false;
                                typeToSet = null;
                                String cellRef = reader.getAttributeValue(null, "r");
                                int columnIndex = SheetDimension.getColumnIndexFromCellRef(cellRef);
                                if (columnIndex <= 0 || (columnIndex -= sheetDimension.getFirstColumnIndex()) < 0 || columnIndex >= columnCount || probedCells[columnIndex] == 10 || valueTypes[columnIndex] == ValueType.VARCHAR) break;
                                columnIndexOfValueToCheck = Optional.of(columnIndex);
                                if ("s".equals(reader.getAttributeValue(null, "t"))) {
                                    typeToSet = ValueType.VARCHAR;
                                    break;
                                }
                                try {
                                    int styleIndex = Integer.parseInt(reader.getAttributeValue(null, "s"));
                                    typeToSet = this.valueTypesOrderedByStyleIndexes.get(styleIndex);
                                }
                                catch (IndexOutOfBoundsException | NumberFormatException ex) {
                                    typeToSet = ValueType.VARCHAR;
                                }
                                ValueType currentType = valueTypes[columnIndex];
                                if ((currentType == null || currentType == ValueType.NUMBER) && typeToSet == ValueType.VARCHAR) {
                                    possibleNumber = true;
                                    break;
                                }
                                if (currentType == null || currentType == typeToSet) continue block24;
                                typeToSet = ValueType.VARCHAR;
                                break;
                            }
                            case "v": {
                                String value;
                                if (!columnIndexOfValueToCheck.isPresent() || (value = reader.getElementText()) == null || value.trim().isEmpty()) break;
                                int colIndex = (Integer)columnIndexOfValueToCheck.get();
                                if (possibleNumber) {
                                    try {
                                        Double.parseDouble(value);
                                        typeToSet = ValueType.NUMBER;
                                    }
                                    catch (NullPointerException | NumberFormatException ex) {
                                        typeToSet = ValueType.VARCHAR;
                                    }
                                    possibleNumber = false;
                                }
                                valueTypes[colIndex] = typeToSet;
                                int n = colIndex;
                                probedCells[n] = probedCells[n] + 1;
                                columnIndexOfValueToCheck = Optional.empty();
                                break;
                            }
                        }
                        continue;
                    }
                    if (reader.getEventType() != 2) continue;
                    localName = reader.getLocalName();
                    if (!insideRow || !"row".equals(localName)) continue;
                    insideRow = false;
                    if (++probedRowCount != 30) continue;
                    break;
                }
                for (int index = 0; index < valueTypes.length; ++index) {
                    if (valueTypes[index] != null) continue;
                    valueTypes[index] = ValueType.VARCHAR;
                }
                this.sheetNamesToColumnTypes.put(sheetName, Arrays.asList(valueTypes));
            }
        }
        catch (IOException | XMLStreamException ex) {
            throw new ExcelParserException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private List<List<Object>> readRows(ZipFile zipFile, String sheetName, int firstRowIndex, int lastRowIndex) {
        try {
            ZipEntry sheetEntry = this.getZipEntryForSheet(zipFile, sheetName);
            try (InputStream is = zipFile.getInputStream(sheetEntry);){
                ArrayList<List<Object>> arrayList;
                XMLStreamReader reader = this.factory.createXMLStreamReader(is);
                try {
                    int requestedRowCount = lastRowIndex - firstRowIndex + 1;
                    int columnCount = this.sheetNamesToColumnNames.get(sheetName).size();
                    SheetDimension sheetDimension = this.sheetNamesToDimensions.get(sheetName);
                    ArrayList<List<Object>> allRows = new ArrayList<List<Object>>();
                    IntStream.range(0, requestedRowCount).forEach(val -> {
                        ArrayList row = new ArrayList();
                        IntStream.range(0, columnCount).forEach(v -> row.add(null));
                        allRows.add(row);
                    });
                    RowData currentRowData = null;
                    RowData.CellData currentCellData = null;
                    block22: while (reader.hasNext()) {
                        String localName;
                        reader.next();
                        if (reader.getEventType() == 1) {
                            localName = reader.getLocalName();
                            if (localName == null) continue;
                            switch (localName) {
                                case "row": {
                                    try {
                                        int rowIndex = Integer.parseInt(reader.getAttributeValue(null, "r"));
                                        if (rowIndex < firstRowIndex || rowIndex > lastRowIndex) continue block22;
                                        currentRowData = new RowData(rowIndex);
                                    }
                                    catch (Exception rowIndex) {}
                                    break;
                                }
                                case "c": {
                                    if (currentRowData == null) break;
                                    currentCellData = new RowData.CellData();
                                    currentCellData.setR(reader.getAttributeValue(null, "r"));
                                    currentCellData.setT(reader.getAttributeValue(null, "t"));
                                    currentCellData.setS(reader.getAttributeValue(null, "s"));
                                    break;
                                }
                                case "v": {
                                    if (currentRowData == null) break;
                                    currentCellData.setV(reader.getElementText());
                                    currentRowData.addCellData(currentCellData);
                                    currentCellData = null;
                                }
                            }
                            continue;
                        }
                        if (reader.getEventType() != 2 || !"row".equals(localName = reader.getLocalName()) || currentRowData == null) continue;
                        List row = (List)allRows.get(currentRowData.getRowIndex() - firstRowIndex);
                        for (RowData.CellData cell : currentRowData.getCellsInRow()) {
                            int columnIndex;
                            Object value = this.getCellValue(zipFile, cell);
                            if (value == null || (columnIndex = SheetDimension.getColumnIndexFromCellRef(cell.getR())) <= 0 || (columnIndex -= sheetDimension.getFirstColumnIndex()) < 0 || columnIndex >= columnCount) continue;
                            row.set(columnIndex, value);
                        }
                        currentRowData = null;
                    }
                    arrayList = allRows;
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return arrayList;
            }
        }
        catch (IOException | XMLStreamException ex) {
            throw new ExcelParserException(ex);
        }
    }

    private Object getCellValue(ZipFile zipFile, RowData.CellData cell) {
        int styleIndex;
        if ("s".equals(cell.getT())) {
            try {
                int index = Integer.parseInt(cell.getV());
                this.initSharedStrings(zipFile);
                return this.sharedStrings.get(index);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        try {
            styleIndex = Integer.parseInt(cell.getS());
        }
        catch (Exception ex) {
            return cell.getV();
        }
        Function<RowData.CellData, Long> toMillis = cellData -> {
            double value = Double.parseDouble(cellData.getV());
            int days = Double.valueOf(value).intValue();
            int seconds = Long.valueOf(Math.round((value - (double)days) * (double)TimeUnit.DAYS.toSeconds(1L))).intValue();
            Calendar cal = Calendar.getInstance();
            cal.set(1900, 0, --days, 0, 0, seconds);
            cal.set(14, 0);
            return new Long(cal.getTime().getTime());
        };
        ValueType valueType = this.valueTypesOrderedByStyleIndexes.get(styleIndex);
        switch (valueType) {
            case DATE: {
                try {
                    return new Date(toMillis.apply(cell));
                }
                catch (Exception ex) {
                    return null;
                }
            }
            case TIME: {
                try {
                    return new Time(toMillis.apply(cell));
                }
                catch (Exception ex) {
                    return null;
                }
            }
            case TIMESTAMP: {
                try {
                    return new Timestamp(toMillis.apply(cell));
                }
                catch (Exception ex) {
                    return null;
                }
            }
            case NUMBER: {
                try {
                    return Double.valueOf(cell.getV());
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return cell.getV();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private int readRowCount(ZipFile zipFile, String sheetName) {
        try {
            ZipEntry sheetEntry = this.getZipEntryForSheet(zipFile, sheetName);
            try (InputStream is = zipFile.getInputStream(sheetEntry);){
                int n;
                XMLStreamReader reader = this.factory.createXMLStreamReader(is);
                try {
                    int rowCount = 0;
                    while (reader.hasNext()) {
                        reader.next();
                        if (reader.getEventType() != 1 || !"row".equals(reader.getLocalName())) continue;
                        try {
                            int rowIndex = Integer.parseInt(reader.getAttributeValue(null, "r"));
                            if (rowIndex <= rowCount) continue;
                            rowCount = rowIndex;
                        }
                        catch (Exception exception) {}
                    }
                    n = rowCount;
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return n;
            }
        }
        catch (IOException | XMLStreamException ex) {
            throw new ExcelParserException(ex);
        }
    }

    public static class ExcelParserException
    extends RuntimeException {
        public ExcelParserException(Throwable cause) {
            super(cause);
        }
    }
}

