/*
 * Decompiled with CFR 0.152.
 */
package com.inet.excel;

import com.inet.excel.ExcelConnection;
import com.inet.excel.parser.ExcelParser;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class ExcelDriver
implements Driver {
    public static final String URL_PREFIX = "jdbc:inetexcel:";
    public static final String DRIVER_NAME = "inetexcel";
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 3;

    static void throwExceptionAboutUnsupportedOperation() throws SQLException {
        throw new SQLException("Unsupported operation");
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        int questionMarkIndex = (url = url.substring(URL_PREFIX.length())).indexOf(63);
        if (questionMarkIndex == 0) {
            throw new SQLException("Excel file is not specified");
        }
        String filePath = null;
        boolean hasHeaderRow = true;
        if (questionMarkIndex == -1) {
            filePath = url;
        } else {
            String[] properties;
            filePath = url.substring(0, questionMarkIndex);
            String propertiesPart = url.substring(questionMarkIndex + 1);
            for (String property : properties = propertiesPart.split("&")) {
                if (!"hasHeaderRow=false".equalsIgnoreCase(property)) continue;
                hasHeaderRow = false;
                break;
            }
        }
        if (filePath.trim().isEmpty()) {
            throw new SQLException("Excel file is not specified");
        }
        Path file = Paths.get(filePath, new String[0]).toAbsolutePath();
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new SQLException("Specified Excel file does not exist");
        }
        ExcelParser parser = new ExcelParser(file, hasHeaderRow);
        return new ExcelConnection(parser);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("URL must not be null");
        }
        return url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

