/*
 * Decompiled with CFR 0.152.
 */
package com.inet.excel.parser;

import com.inet.excel.parser.ValueType;

public class FormatCodeAnalyzer {
    public static ValueType recognizeValueType(String formatCode) {
        if (formatCode == null || formatCode.trim().isEmpty()) {
            return ValueType.VARCHAR;
        }
        if (FormatCodeAnalyzer.countQuoteCharacters(formatCode = formatCode.toLowerCase()) % 2 != 0) {
            return ValueType.VARCHAR;
        }
        boolean containsTime = FormatCodeAnalyzer.containsTime(formatCode);
        boolean containsDate = FormatCodeAnalyzer.containsDate(formatCode);
        if (containsTime && containsDate) {
            return ValueType.TIMESTAMP;
        }
        if (containsTime) {
            return ValueType.TIME;
        }
        if (containsDate) {
            return ValueType.DATE;
        }
        return ValueType.VARCHAR;
    }

    private static boolean containsTime(String formatCode) {
        if (FormatCodeAnalyzer.containsUnescapedSubstring(formatCode, "h")) {
            return true;
        }
        if (FormatCodeAnalyzer.containsUnescapedSubstring(formatCode, "h:m")) {
            return true;
        }
        if (FormatCodeAnalyzer.containsUnescapedSubstring(formatCode, "m:s")) {
            return true;
        }
        return FormatCodeAnalyzer.containsUnescapedSubstring(formatCode, "s");
    }

    private static boolean containsDate(String formatCode) {
        if (FormatCodeAnalyzer.containsUnescapedSubstring(formatCode, "y")) {
            return true;
        }
        if (FormatCodeAnalyzer.containsUnescapedSubstring(formatCode, "d")) {
            return true;
        }
        formatCode = formatCode.replace("h:mm", "");
        formatCode = formatCode.replace("h:m", "");
        formatCode = formatCode.replace("mm:s", "");
        formatCode = formatCode.replace("m:s", "");
        return FormatCodeAnalyzer.containsUnescapedSubstring(formatCode = formatCode.replace("am/pm", ""), "m");
    }

    private static boolean containsUnescapedSubstring(String formatCode, String substring) {
        int index = formatCode.indexOf(substring);
        if (index == 0) {
            return true;
        }
        while (index > 0) {
            if (FormatCodeAnalyzer.isInsideQuotes(formatCode, index) || FormatCodeAnalyzer.isEscapedWithBackslash(formatCode, index)) {
                if (index + 1 >= formatCode.length()) break;
                index = formatCode.indexOf(substring, index + 1);
                continue;
            }
            return true;
        }
        return false;
    }

    private static boolean isInsideQuotes(String formatCode, int charIndex) {
        String before = formatCode.substring(0, charIndex);
        return FormatCodeAnalyzer.countQuoteCharacters(before) % 2 == 1;
    }

    private static boolean isEscapedWithBackslash(String formatCode, int charIndex) {
        if (charIndex == 0) {
            return false;
        }
        int backslashCount = 0;
        while (charIndex > 0 && formatCode.charAt(--charIndex) == '\\') {
            ++backslashCount;
        }
        return backslashCount % 2 == 1;
    }

    private static int countQuoteCharacters(String formatCode) {
        int count = 0;
        int index = 0;
        while ((index = formatCode.indexOf("\"", index)) > -1) {
            if (!FormatCodeAnalyzer.isEscapedWithBackslash(formatCode, index)) {
                ++count;
            }
            ++index;
        }
        return count;
    }
}

