/*
 * Decompiled with CFR 0.152.
 */
package com.inet.excel;

import com.inet.excel.ExcelDriver;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class ExcelSheetResultSetMetaData
implements ResultSetMetaData {
    private String fileName;
    private String sheetName;
    private List<String> columnNames;

    public ExcelSheetResultSetMetaData(String fileName, String sheetName, List<String> columnNames) {
        if (fileName == null) {
            throw new IllegalArgumentException("file name must not be null");
        }
        if (sheetName == null) {
            throw new IllegalArgumentException("sheet name must not be null");
        }
        if (columnNames == null) {
            throw new IllegalArgumentException("list of column names must not be null");
        }
        this.fileName = fileName;
        this.sheetName = sheetName;
        this.columnNames = columnNames;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnNames.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnNames.get(column - 1);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 65535;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.sheetName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.fileName;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return 2000;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return "JAVA_OBJECT";
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return String.class.getName();
    }
}

