/*
 * Decompiled with CFR 0.152.
 */
package com.inet.excel;

import com.inet.excel.ExcelResultSet;
import com.inet.excel.ExcelSheetResultSetMetaData;
import com.inet.excel.parser.ExcelParser;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class ExcelSheetResultSet
extends ExcelResultSet {
    private final ExcelParser parser;
    private final String sheetName;
    private final int maxRowsPerBatch;
    private final ResultSetMetaData metaData;
    private final int rowCount;
    private List<List<Object>> rowBatch;
    private int currentRowIndex;
    private int currentBatchIndex;
    private boolean closed;

    public ExcelSheetResultSet(ExcelParser parser, String sheetName, int maxRowsPerBatch) {
        super(ExcelSheetResultSet.getColumnNames(parser, sheetName));
        if (maxRowsPerBatch <= 0) {
            throw new IllegalArgumentException("max number of rows per batch must be greater than zero");
        }
        this.parser = parser;
        this.sheetName = sheetName;
        this.maxRowsPerBatch = maxRowsPerBatch;
        this.metaData = new ExcelSheetResultSetMetaData(parser.getFileName(), sheetName, this.getColumnNames());
        this.rowCount = parser.getRowCount(sheetName);
        this.currentRowIndex = -1;
        this.currentBatchIndex = -1;
        this.closed = false;
    }

    private static List<String> getColumnNames(ExcelParser parser, String sheetName) {
        if (parser == null) {
            throw new IllegalArgumentException("parser must not be null");
        }
        if (sheetName == null) {
            throw new IllegalArgumentException("sheet name must not be null");
        }
        return parser.getColumnNames(sheetName);
    }

    @Override
    public boolean next() throws SQLException {
        this.throwIfAlreadyClosed();
        if (this.currentRowIndex + 1 >= this.rowCount) {
            this.currentRowIndex = this.rowCount;
            return false;
        }
        if (this.currentBatchIndex == -1 || this.currentBatchIndex == this.rowBatch.size() - 1) {
            int firstRowIndex = this.currentRowIndex + 2;
            int lastRowIndex = firstRowIndex + this.maxRowsPerBatch - 1;
            this.rowBatch = this.parser.getRows(this.sheetName, firstRowIndex, Math.min(lastRowIndex, this.rowCount));
            this.currentBatchIndex = 0;
        } else {
            ++this.currentBatchIndex;
        }
        ++this.currentRowIndex;
        return true;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.throwIfAlreadyClosed();
        return this.metaData;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.throwIfAlreadyClosed();
        return this.currentRowIndex >= this.rowCount;
    }

    @Override
    public int getRow() throws SQLException {
        this.throwIfAlreadyClosed();
        if (this.currentRowIndex >= this.rowCount) {
            return 0;
        }
        return this.currentRowIndex + 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    protected <T> T getValue(int columnIndex) throws SQLException {
        this.throwIfAlreadyClosedOrReachedEnd();
        this.throwIfColumnIndexIsInvalid(columnIndex);
        return (T)this.rowBatch.get(this.currentBatchIndex).get(columnIndex - 1);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.throwIfAlreadyClosed();
        return false;
    }
}

