/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring;

import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

public class SerializerMessageConverter
extends AbstractMessageConverter {
    public static final MimeType MIME_TYPE = new MimeType("application", "iip");
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializerMessageConverter.class);

    public SerializerMessageConverter() {
        super(MIME_TYPE);
    }

    public SerializerMessageConverter(MimeType mimeType) {
        super(mimeType);
    }

    protected boolean supports(Class<?> clazz) {
        return SerializerRegistry.hasSerializer(clazz);
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        Object payload = message.getPayload();
        Serializer serializer = SerializerRegistry.getSerializer(targetClass);
        if (null != serializer) {
            try {
                payload = serializer.from((Object)((byte[])payload));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            LOGGER.error("No serializer found for " + payload.getClass().getName() + " although type seems to be supported");
        }
        return payload;
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        return this.serialize(payload);
    }

    private <T> Object serialize(T payload) {
        Object result;
        Serializer serializer = SerializerRegistry.getSerializer(payload.getClass());
        if (null != serializer) {
            try {
                result = serializer.to(payload);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            LOGGER.error("No serializer found for " + payload.getClass().getName() + " although type seems to be supported");
            result = payload;
        }
        return result;
    }

    public static <T> void serializeAndSend(StreamBridge streamBridge, String bindingName, T payload) {
        Serializer serializer = SerializerRegistry.getSerializer(payload.getClass());
        if (null != serializer) {
            try {
                streamBridge.send(bindingName, (Object)MessageBuilder.withPayload((Object)serializer.to(payload)).build());
            }
            catch (IOException e) {
                LOGGER.error("Cannot send instance of " + payload.getClass().getName() + ": " + e.getMessage());
            }
        } else {
            LOGGER.error("No serializer found for " + payload.getClass().getName() + " although type seems to be supported. Cannot send instance.");
        }
    }
}

