/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring;

import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import de.iip_ecosphere.platform.transport.spring.SerializerConfiguration;
import de.iip_ecosphere.platform.transport.spring.TransportFactoryConfiguration;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={SerializerConfiguration.class, TransportFactoryConfiguration.class})
public class StartupApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartupApplicationListener.class);
    @Autowired
    private SerializerConfiguration cfg;
    @Autowired
    private TransportFactoryConfiguration transportCfg;
    private boolean done = false;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.done) {
            this.registerSerializers();
            this.configureTransportFactory();
            this.done = true;
        }
    }

    private void registerSerializers() {
        for (String s : this.cfg.getSerializers()) {
            Serializer ser = this.obtainInstance(s, "Serializer registration:", Serializer.class);
            if (null == ser) continue;
            SerializerRegistry.registerSerializer((Serializer)ser);
            LOGGER.info("Registered Serializer " + s);
        }
        SerializerRegistry.setName((String)this.cfg.getName());
    }

    private void configureTransportFactory() {
        TransportFactory.ConnectorCreator cr = this.obtainConnectorCreator(this.transportCfg.getMainTransportClassName(), "Configuring main transport connector");
        if (null != cr) {
            TransportFactory.setMainImplementation((TransportFactory.ConnectorCreator)cr);
            LOGGER.error("Registered main transport connector " + this.transportCfg.getMainTransportClassName());
        }
        if (null != (cr = this.obtainConnectorCreator(this.transportCfg.getDirectMemoryClassName(), "Configuring direct memory transport connector"))) {
            TransportFactory.setDmImplementation((TransportFactory.ConnectorCreator)cr);
            LOGGER.error("Registered direct-memory transport connector " + this.transportCfg.getDirectMemoryClassName());
        }
        if (null != (cr = this.obtainConnectorCreator(this.transportCfg.getInterProcessClassName(), "Configuring inter-process transport connector"))) {
            TransportFactory.setIpcImplementation((TransportFactory.ConnectorCreator)cr);
            LOGGER.error("Registered inter-process transport connector " + this.transportCfg.getInterProcessClassName());
        }
    }

    @Nullable
    private TransportFactory.ConnectorCreator obtainConnectorCreator(String className, String context) {
        TransportConnector conn;
        TransportFactory.ConnectorCreator result = null;
        if (className.length() > 0 && null != (conn = this.obtainInstance(className, context, TransportConnector.class))) {
            final Class<?> cls = conn.getClass();
            final String name = conn.getName();
            result = new TransportFactory.ConnectorCreator(){

                public TransportConnector createConnector() {
                    TransportConnector result;
                    try {
                        result = (TransportConnector)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        result = null;
                    }
                    return result;
                }

                public String getName() {
                    return name;
                }
            };
        }
        return result;
    }

    private <T> T obtainInstance(String className, String context, Class<? extends T> type) {
        T result;
        try {
            result = type.cast(Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            result = null;
            LOGGER.error(context + ": class " + className + " cannot be created: " + e.getMessage());
        }
        return result;
    }
}

