/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport.spring;

import de.iip_ecosphere.platform.transport.spring.SerializerMessageConverter;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.stream.binder.test.InputDestination;
import org.springframework.cloud.stream.binder.test.TestChannelBinderConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.MimeType;
import test.de.iip_ecosphere.platform.transport.spring.TestCounters;

@SpringBootTest(classes={StreamTest.class})
@RunWith(value=SpringRunner.class)
@ComponentScan(basePackages={"de.iip_ecosphere.platform.transport.spring"})
public class StreamTest {
    @Test
    public void testStream() {
        TestCounters.reset();
        try (ConfigurableApplicationContext context = new SpringApplicationBuilder(TestChannelBinderConfiguration.getCompleteConfiguration((Class[])new Class[]{MyProcessor.class})).run(new String[0]);){
            InputDestination source = (InputDestination)context.getBean(InputDestination.class);
            source.send((Message)new GenericMessage((Object)"DMG-1".getBytes()));
            Assert.assertEquals((long)1L, (long)TestCounters.getFromCount());
            Assert.assertEquals((long)1L, (long)TestCounters.getToCount());
            Assert.assertEquals((long)0L, (long)TestCounters.getCloneCount());
        }
    }

    @SpringBootApplication
    public static class MyProcessor {
        @Bean
        public Function<String, String> transform() {
            return in -> in + " world";
        }

        @Bean
        public MessageConverter customMessageConverter() {
            return new SerializerMessageConverter(new MimeType("application", "ser-string"));
        }
    }
}

