/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport.spring;

import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.spring.BeanHelper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.test.context.junit4.SpringRunner;
import test.de.iip_ecosphere.platform.transport.spring.TransportFactoryConfigurationTest;

@SpringBootTest(classes={TransportFactoryConfigurationTest.class})
@RunWith(value=SpringRunner.class)
@ComponentScan(basePackages={"de.iip_ecosphere.platform.transport.spring"})
public class BeanHelperTest {
    @Autowired
    private ApplicationContext ctx;

    @Test
    public void testBeanHelper() {
        String beanName = "myTpBean";
        TransportParameter bean = TransportParameter.TransportParameterBuilder.newBuilder((String)"h", (int)1111).setApplicationId("c").build();
        AnnotationConfigApplicationContext child = new AnnotationConfigApplicationContext();
        child.setParent(this.ctx);
        BeanHelper.registerInParentContext((ApplicationContext)child, (Object)bean, (String)"myTpBean");
        Assert.assertTrue((boolean)child.containsBean("myTpBean"));
        Assert.assertTrue((child.getParent().getBean(TransportParameter.class) == bean ? 1 : 0) != 0);
        Assert.assertTrue((child.getParent().getBean("myTpBean") == bean ? 1 : 0) != 0);
        BeanHelper.registerInParentContext((ApplicationContext)child, (Object)bean);
        Assert.assertTrue((boolean)child.containsBean("myTpBean"));
    }
}

