/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.mqttv3;

import de.iip_ecosphere.platform.transport.spring.binder.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;

public class MqttV3MessageProducer
extends MessageProducerSupport {
    private final ConsumerDestination destination;

    public MqttV3MessageProducer(ConsumerDestination destination) {
        this.destination = destination;
    }

    public void doStart() {
        MqttClient.subscribeTo(this.destination.getName(), new Callback());
    }

    protected void doStop() {
        MqttClient.unsubscribeFrom(this.destination.getName());
    }

    private class Callback
    implements MqttClient.ArrivedCallback {
        private Callback() {
        }

        @Override
        public void messageArrived(String topic, MqttMessage message) {
            byte[] payload = message.getPayload();
            Message msg = MessageBuilder.withPayload((Object)payload).build();
            MqttV3MessageProducer.this.sendMessage(msg);
        }
    }
}

