/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.mqttv3;

import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.connectors.basics.MqttQoS;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="mqtt")
public class MqttConfiguration {
    private String host;
    private int port;
    private String schema = "tcp";
    private String clientId;
    private boolean autoClientId = true;
    private int keepAlive = 60000;
    private int actionTimeout = 1000;
    private List<String> filteredTopics = new ArrayList<String>();
    private String qos = MqttQoS.AT_LEAST_ONCE.name();

    public boolean isFilteredTopic(String topic) {
        return this.filteredTopics.contains(topic);
    }

    public List<String> getFilteredTopics() {
        return this.filteredTopics;
    }

    public String getHost() {
        return this.host;
    }

    public String getBrokerString() {
        return String.valueOf(this.getSchema()) + "://" + this.getHost() + ":" + this.getPort();
    }

    public int getPort() {
        return this.port;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean getAutoClientId() {
        return this.autoClientId;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public int getActionTimeout() {
        return this.actionTimeout;
    }

    public MqttQoS getQos() {
        return MqttQoS.valueOf((String)this.qos);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setAutoClientId(boolean autoClientId) {
        this.autoClientId = autoClientId;
    }

    public void setKeepAlive(int keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setActionTimeout(int actionTimeout) {
        this.actionTimeout = actionTimeout;
    }

    public void setFilteredTopics(List<String> filteredTopics) {
        this.filteredTopics = filteredTopics;
    }

    public void setQos(String qos) {
        try {
            MqttQoS.valueOf((String)qos.toUpperCase());
            this.qos = qos.toUpperCase();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public TransportParameter toTransportParameter() {
        return TransportParameter.TransportParameterBuilder.newBuilder((String)this.getHost(), (int)this.getPort()).setApplicationId(this.getClientId()).setAutoApplicationId(this.getAutoClientId()).setActionTimeout(this.getActionTimeout()).setKeepAlive(this.getKeepAlive()).build();
    }
}

