/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.mqttv3;

import de.iip_ecosphere.platform.transport.connectors.basics.MqttQoS;
import de.iip_ecosphere.platform.transport.connectors.impl.AbstractTransportConnector;
import de.iip_ecosphere.platform.transport.spring.binder.mqttv3.MqttConfiguration;
import de.iip_ecosphere.platform.transport.spring.binder.mqttv3.MqttV3MessageBinder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttV3MessageBinder.class);
    private static MqttAsyncClient client;
    private static MqttConfiguration configuration;
    private static Callback callback;
    private static MqttQoS qos;

    static {
        qos = MqttQoS.AT_LEAST_ONCE;
    }

    static synchronized void createClient(MqttConfiguration config) {
        if (client == null) {
            try {
                configuration = config;
                qos = config.getQos();
                String clientId = AbstractTransportConnector.getApplicationId((String)config.getClientId(), (String)"stream", (boolean)config.getAutoClientId());
                LOGGER.info("Connecting to " + config.getBrokerString() + " with client id " + clientId);
                MqttAsyncClient cl = new MqttAsyncClient(config.getBrokerString(), config.getClientId(), (MqttClientPersistence)new MemoryPersistence());
                callback = new Callback();
                cl.setCallback((MqttCallback)callback);
                MqttConnectOptions connOpts = new MqttConnectOptions();
                connOpts.setCleanSession(false);
                connOpts.setKeepAliveInterval(config.getKeepAlive());
                connOpts.setAutomaticReconnect(true);
                MqttClient.waitForCompletion(cl.connect(connOpts));
                client = cl;
            }
            catch (MqttException e) {
                LOGGER.error("Connecting MQTT client: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void stopClient() {
        try {
            MqttClient.waitForCompletion(client.disconnect());
            client.close();
            callback = null;
            client = null;
        }
        catch (MqttException e) {
            LOGGER.error("Stopping MQTT client: " + e.getMessage(), (Throwable)e);
        }
    }

    static boolean subscribeTo(String topic, ArrivedCallback arrivedCallback) {
        boolean done = false;
        if (!configuration.isFilteredTopic(topic) && client != null) {
            try {
                callback.callbacks.put(topic, arrivedCallback);
                MqttClient.waitForCompletion(client.subscribe(topic, MqttQoS.AT_LEAST_ONCE.value()));
                LOGGER.info("Subscribed to " + topic);
                done = true;
            }
            catch (MqttException e) {
                LOGGER.error("Subscribing to MQTT topic '" + topic + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return done;
    }

    static boolean unsubscribeFrom(String topic) {
        boolean done = false;
        if (!configuration.isFilteredTopic(topic) && client != null) {
            try {
                callback.callbacks.remove(topic);
                MqttClient.waitForCompletion(client.unsubscribe(topic));
                LOGGER.info("Unsubscribed from " + topic);
                done = true;
            }
            catch (MqttException e) {
                LOGGER.error("Unsubscribing from MQTT topic '" + topic + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return done;
    }

    static void send(String topic, byte[] payload) {
        if (client != null) {
            MqttMessage message = new MqttMessage(payload);
            message.setQos(qos.value());
            try {
                client.publish(topic, message);
            }
            catch (MqttException e) {
                LOGGER.error("Sending MQTT message with topic " + topic + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    static void waitForCompletion(IMqttToken token) throws MqttException {
        token.waitForCompletion((long)configuration.getActionTimeout());
    }

    public static interface ArrivedCallback {
        public void messageArrived(String var1, MqttMessage var2);
    }

    private static class Callback
    implements MqttCallback {
        private Map<String, ArrivedCallback> callbacks = Collections.synchronizedMap(new HashMap());

        private Callback() {
        }

        public void connectionLost(Throwable cause) {
            LOGGER.info("Connection lost: " + cause.getMessage());
        }

        public void messageArrived(String topic, MqttMessage message) throws Exception {
            ArrivedCallback cb = this.callbacks.get(topic);
            if (cb != null) {
                cb.messageArrived(topic, message);
            }
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }
    }
}

